/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteFullException;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.util.Counters;

public class SqlTileWriter
implements IFilesystemCache {
    public static final String DATABASE_FILENAME = "cache.db";
    public static final String COLUMN_EXPIRES = "expires";
    public static boolean CLEANUP_ON_START = true;
    protected File db_file;
    protected SQLiteDatabase db;
    final int questimate = 4000;
    static boolean hasInited = false;

    public SqlTileWriter() {
        Configuration.getInstance().getOsmdroidTileCache().mkdirs();
        this.db_file = new File(Configuration.getInstance().getOsmdroidTileCache().getAbsolutePath() + File.separator + DATABASE_FILENAME);
        try {
            this.db = SQLiteDatabase.openOrCreateDatabase((File)this.db_file, null);
            this.db.execSQL("CREATE TABLE IF NOT EXISTS tiles (key INTEGER , provider TEXT, tile BLOB, expires INTEGER, PRIMARY KEY (key, provider));");
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)"Unable to start the sqlite tile writer. Check external storage availability.", (Throwable)ex);
        }
        if (!hasInited) {
            hasInited = true;
            if (CLEANUP_ON_START) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        SqlTileWriter.this.runCleanupOperation();
                    }
                };
                t.setPriority(1);
                t.start();
            }
        }
    }

    public void runCleanupOperation() {
        block8: {
            if (this.db == null) {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)"Finished init thread, aborted due to null database reference");
                }
                return;
            }
            try {
                if (this.db_file.length() <= Configuration.getInstance().getTileFileSystemCacheMaxBytes()) break block8;
                long now = System.currentTimeMillis();
                Log.d((String)"OsmDroid", (String)("Local cache is now " + this.db_file.length() + " max size is " + Configuration.getInstance().getTileFileSystemCacheMaxBytes()));
                long diff = this.db_file.length() - Configuration.getInstance().getTileFileSystemCacheMaxBytes();
                long tilesToKill = diff / 4000L;
                Log.d((String)"OsmDroid", (String)("Local cache purging " + tilesToKill + " tiles."));
                if (tilesToKill > 0L) {
                    try {
                        this.db.execSQL("DELETE FROM tiles WHERE key in (SELECT key FROM tiles ORDER BY expires DESC LIMIT " + tilesToKill + ")");
                    }
                    catch (Throwable t) {
                        Log.e((String)"OsmDroid", (String)"error purging tiles from the tile cache", (Throwable)t);
                    }
                }
                Log.d((String)"OsmDroid", (String)("purge completed in " + (System.currentTimeMillis() - now) + "ms, cache size is " + this.db_file.length() + " bytes"));
            }
            catch (Exception ex) {
                if (!Configuration.getInstance().isDebugMode()) break block8;
                Log.d((String)"OsmDroid", (String)"SqliteTileWriter init thread crash, db is probably not available", (Throwable)ex);
            }
        }
        if (Configuration.getInstance().isDebugMode()) {
            Log.d((String)"OsmDroid", (String)"Finished init thread");
        }
    }

    @Override
    public boolean saveFile(ITileSource pTileSourceInfo, MapTile pTile, InputStream pStream) {
        if (this.db == null || !this.db.isOpen()) {
            Log.d((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + pTile.toString() + ", database not available."));
            ++Counters.fileCacheSaveErrors;
            return false;
        }
        try {
            ContentValues cv = new ContentValues();
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            cv.put("provider", pTileSourceInfo.name());
            BufferedInputStream bis = new BufferedInputStream(pStream);
            ArrayList<Byte> list = new ArrayList<Byte>();
            int current = 0;
            while ((current = bis.read()) != -1) {
                list.add((byte)current);
            }
            byte[] bits = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                bits[i] = (Byte)list.get(i);
            }
            cv.put("key", Long.valueOf(index));
            cv.put("tile", bits);
            if (pTile.getExpires() != null) {
                cv.put(COLUMN_EXPIRES, Long.valueOf(pTile.getExpires().getTime()));
            }
            this.db.delete("tiles", "key=? and provider=?", new String[]{index + "", pTileSourceInfo.name()});
            this.db.insert("tiles", null, cv);
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("tile inserted " + pTileSourceInfo.name() + pTile.toString()));
            }
            if (this.db_file != null && this.db_file.length() > Configuration.getInstance().getTileFileSystemCacheTrimBytes()) {
                this.runCleanupOperation();
            }
        }
        catch (SQLiteFullException ex) {
            this.runCleanupOperation();
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + pTile.toString() + " db is " + (this.db == null ? "null" : "not null")), (Throwable)ex);
            ++Counters.fileCacheSaveErrors;
        }
        return false;
    }

    public boolean exists(String pTileSource, MapTile pTile) {
        if (this.db == null || !this.db.isOpen()) {
            Log.d((String)"OsmDroid", (String)("Unable to test for tile exists cached tile from " + pTileSource + " " + pTile.toString() + ", database not available."));
            return false;
        }
        try {
            String[] tile = new String[]{"tile"};
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            Cursor cur = this.db.query("tiles", tile, "key = " + index + " and " + "provider" + " = '" + pTileSource + "'", null, null, null, null);
            if (cur.getCount() != 0) {
                cur.close();
                return true;
            }
            cur.close();
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSource + " " + pTile.toString()), (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean exists(ITileSource pTileSource, MapTile pTile) {
        return this.exists(pTileSource.name(), pTile);
    }

    @Override
    public void onDetach() {
        if (this.db != null && this.db.isOpen()) {
            try {
                this.db.close();
                Log.i((String)"OsmDroid", (String)"Database detached");
            }
            catch (Exception ex) {
                Log.e((String)"OsmDroid", (String)"Database detach failed", (Throwable)ex);
            }
        }
        this.db = null;
        this.db_file = null;
    }

    public boolean purgeCache() {
        if (this.db != null && this.db.isOpen()) {
            try {
                this.db.delete("tiles", null, null);
                return true;
            }
            catch (Throwable e) {
                Log.w((String)"OsmDroid", (String)"Error purging the db", (Throwable)e);
            }
        }
        return false;
    }

    public boolean purgeCache(String mTileSourceName) {
        if (this.db != null && this.db.isOpen()) {
            try {
                this.db.delete("tiles", "provider = ?", new String[]{mTileSourceName});
                return true;
            }
            catch (Throwable e) {
                Log.w((String)"OsmDroid", (String)"Error purging the db", (Throwable)e);
            }
        }
        return false;
    }

    public int[] importFromFileCache(boolean removeFromFileSystem) {
        File[] tileSources;
        int[] ret = new int[]{0, 0, 0, 0};
        File tilePathBase = Configuration.getInstance().getOsmdroidTileCache();
        if (tilePathBase.exists() && (tileSources = tilePathBase.listFiles()) != null) {
            for (int i = 0; i < tileSources.length; ++i) {
                if (!tileSources[i].isDirectory() || tileSources[i].isHidden()) continue;
                File[] z = tileSources[i].listFiles();
                if (z != null) {
                    for (int zz = 0; zz < z.length; ++zz) {
                        File[] x;
                        if (z[zz].isDirectory() && !z[zz].isHidden() && (x = z[zz].listFiles()) != null) {
                            for (int xx = 0; xx < x.length; ++xx) {
                                if (x[xx].isDirectory() && !x[xx].isHidden()) {
                                    File[] y = x[xx].listFiles();
                                    if (x != null) {
                                        for (int yy = 0; yy < y.length; ++yy) {
                                            if (y[yy].isHidden() || y[yy].isDirectory()) continue;
                                            try {
                                                ContentValues cv = new ContentValues();
                                                long x1 = Long.parseLong(x[xx].getName());
                                                long y1 = Long.parseLong(y[yy].getName().substring(0, y[yy].getName().indexOf(".")));
                                                long z1 = Long.parseLong(z[zz].getName());
                                                long index = ((z1 << (int)z1) + x1 << (int)z1) + y1;
                                                cv.put("provider", tileSources[i].getName());
                                                if (this.exists(tileSources[i].getName(), new MapTile((int)z1, (int)x1, (int)y1))) continue;
                                                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(y[yy]));
                                                ArrayList<Byte> list = new ArrayList<Byte>();
                                                int current = 0;
                                                while ((current = bis.read()) != -1) {
                                                    list.add((byte)current);
                                                }
                                                byte[] bits = new byte[list.size()];
                                                for (int bi = 0; bi < list.size(); ++bi) {
                                                    bits[bi] = (Byte)list.get(bi);
                                                }
                                                cv.put("key", Long.valueOf(index));
                                                cv.put("tile", bits);
                                                long insert = this.db.insert("tiles", null, cv);
                                                if (insert > 0L) {
                                                    if (Configuration.getInstance().isDebugMode()) {
                                                        Log.d((String)"OsmDroid", (String)("tile inserted " + tileSources[i].getName() + "/" + z1 + "/" + x1 + "/" + y1));
                                                    }
                                                    ret[0] = ret[0] + 1;
                                                    if (!removeFromFileSystem) continue;
                                                    try {
                                                        y[yy].delete();
                                                        ret[2] = ret[2] + 1;
                                                    }
                                                    catch (Exception ex) {
                                                        ret[3] = ret[3] + 1;
                                                    }
                                                    continue;
                                                }
                                                Log.w((String)"OsmDroid", (String)("tile NOT inserted " + tileSources[i].getName() + "/" + z1 + "/" + x1 + "/" + y1));
                                                continue;
                                            }
                                            catch (Throwable ex) {
                                                Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + tileSources[i].getName() + " db is " + (this.db == null ? "null" : "not null")), (Throwable)ex);
                                                ret[1] = ret[1] + 1;
                                            }
                                        }
                                    }
                                }
                                if (!removeFromFileSystem) continue;
                                try {
                                    x[xx].delete();
                                    continue;
                                }
                                catch (Exception ex) {
                                    Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + x[xx].getAbsolutePath()), (Throwable)ex);
                                    ret[3] = ret[3] + 1;
                                }
                            }
                        }
                        if (!removeFromFileSystem) continue;
                        try {
                            z[zz].delete();
                            continue;
                        }
                        catch (Exception ex) {
                            Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + z[zz].getAbsolutePath()), (Throwable)ex);
                            ret[3] = ret[3] + 1;
                        }
                    }
                }
                if (!removeFromFileSystem) continue;
                try {
                    tileSources[i].delete();
                    continue;
                }
                catch (Exception ex) {
                    Log.e((String)"OsmDroid", (String)("Unable to delete directory from " + tileSources[i].getAbsolutePath()), (Throwable)ex);
                    ret[3] = ret[3] + 1;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean remove(ITileSource pTileSourceInfo, MapTile pTile) {
        if (this.db == null) {
            Log.d((String)"OsmDroid", (String)("Unable to delete cached tile from " + pTileSourceInfo.name() + " " + pTile.toString() + ", database not available."));
            ++Counters.fileCacheSaveErrors;
            return false;
        }
        try {
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            this.db.delete("tiles", "key=? and provider=?", new String[]{index + "", pTileSourceInfo.name()});
            return true;
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to delete cached tile from " + pTileSourceInfo.name() + " " + pTile.toString() + " db is " + (this.db == null ? "null" : "not null")), (Throwable)ex);
            ++Counters.fileCacheSaveErrors;
            return false;
        }
    }

    public long getRowCount(String tileSourceName) {
        try {
            Cursor mCount = null;
            mCount = tileSourceName == null ? this.db.rawQuery("select count(*) from tiles", null) : this.db.rawQuery("select count(*) from tiles where provider='" + tileSourceName + "'", null);
            mCount.moveToFirst();
            long count = mCount.getLong(0);
            mCount.close();
            return count;
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to query for row count " + tileSourceName), (Throwable)ex);
            return 0L;
        }
    }
}

