/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;

public class SqliteArchiveTileWriter
implements IFilesystemCache {
    final File db_file;
    final SQLiteDatabase db;
    final int questimate = 8000;
    static boolean hasInited = false;

    public SqliteArchiveTileWriter(String outputFile) throws Exception {
        this.db_file = new File(outputFile);
        try {
            this.db = SQLiteDatabase.openOrCreateDatabase((String)this.db_file.getAbsolutePath(), null);
        }
        catch (Exception ex) {
            throw new Exception("Trouble creating database file at " + outputFile, ex);
        }
        try {
            this.db.execSQL("CREATE TABLE IF NOT EXISTS tiles (key INTEGER , provider TEXT, tile BLOB, PRIMARY KEY (key, provider));");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Log.d((String)"OsmDroid", (String)"error setting db schema, it probably exists already", (Throwable)t);
        }
    }

    @Override
    public boolean saveFile(ITileSource pTileSourceInfo, MapTile pTile, InputStream pStream) {
        try {
            ContentValues cv = new ContentValues();
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            cv.put("provider", pTileSourceInfo.name());
            BufferedInputStream bis = new BufferedInputStream(pStream);
            ArrayList<Byte> list = new ArrayList<Byte>();
            int current = 0;
            while ((current = bis.read()) != -1) {
                list.add((byte)current);
            }
            byte[] bits = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                bits[i] = (Byte)list.get(i);
            }
            cv.put("key", Long.valueOf(index));
            cv.put("tile", bits);
            this.db.insert("tiles", null, cv);
            if (Configuration.getInstance().isDebugMode()) {
                Log.d((String)"OsmDroid", (String)("tile inserted " + pTileSourceInfo.name() + pTile.toString()));
            }
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSourceInfo.name() + " " + pTile.toString()), (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean exists(ITileSource pTileSource, MapTile pTile) {
        try {
            String[] tile = new String[]{"tile"};
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            Cursor cur = this.db.query("tiles", tile, "key = " + index + " and " + "provider" + " = '" + pTileSource.name() + "'", null, null, null, null);
            if (cur.getCount() != 0) {
                cur.close();
                return true;
            }
            cur.close();
        }
        catch (Throwable ex) {
            Log.e((String)"OsmDroid", (String)("Unable to store cached tile from " + pTileSource.name() + " " + pTile.toString()), (Throwable)ex);
        }
        return false;
    }

    @Override
    public void onDetach() {
        if (this.db != null) {
            this.db.close();
        }
    }

    @Override
    public boolean remove(ITileSource tileSource, MapTile tile) {
        return false;
    }
}

