/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.GEMFFile;

public class GEMFFileArchive
implements IArchiveFile {
    private GEMFFile mFile;

    public GEMFFileArchive() {
    }

    private GEMFFileArchive(File pFile) throws FileNotFoundException, IOException {
        this.mFile = new GEMFFile(pFile);
    }

    public static GEMFFileArchive getGEMFFileArchive(File pFile) throws FileNotFoundException, IOException {
        return new GEMFFileArchive(pFile);
    }

    @Override
    public void init(File pFile) throws Exception {
        this.mFile = new GEMFFile(pFile);
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, MapTile pTile) {
        return this.mFile.getInputStream(pTile.getX(), pTile.getY(), pTile.getZoomLevel());
    }

    @Override
    public Set<String> getTileSources() {
        HashSet<String> ret = new HashSet<String>();
        try {
            ret.addAll(this.mFile.getSources().values());
        }
        catch (Exception e) {
            Log.w((String)"OsmDroid", (String)"Error getting tile sources: ", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void close() {
        try {
            this.mFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "GEMFFileArchive [mGEMFFile=" + this.mFile.getName() + "]";
    }
}

