/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.ConfigurablePriorityThreadFactory;
import org.osmdroid.tileprovider.tilesource.ITileSource;

public abstract class MapTileModuleProviderBase {
    private final ExecutorService mExecutor;
    protected final Object mQueueLockObject = new Object();
    protected final HashMap<MapTile, MapTileRequestState> mWorking;
    protected final LinkedHashMap<MapTile, MapTileRequestState> mPending;

    protected abstract String getName();

    protected abstract String getThreadGroupName();

    protected abstract Runnable getTileLoader();

    public abstract boolean getUsesDataConnection();

    public abstract int getMinimumZoomLevel();

    public abstract int getMaximumZoomLevel();

    public abstract void setTileSource(ITileSource var1);

    public MapTileModuleProviderBase(int pThreadPoolSize, final int pPendingQueueSize) {
        if (pPendingQueueSize < pThreadPoolSize) {
            Log.w((String)"OsmDroid", (String)"The pending queue size is smaller than the thread pool size. Automatically reducing the thread pool size.");
            pThreadPoolSize = pPendingQueueSize;
        }
        this.mExecutor = Executors.newFixedThreadPool(pThreadPoolSize, new ConfigurablePriorityThreadFactory(5, this.getThreadGroupName()));
        this.mWorking = new HashMap();
        this.mPending = new LinkedHashMap<MapTile, MapTileRequestState>(pPendingQueueSize + 2, 0.1f, true){
            private static final long serialVersionUID = 6455337315681858866L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<MapTile, MapTileRequestState> pEldest) {
                if (this.size() > pPendingQueueSize) {
                    MapTile result = null;
                    Iterator<MapTile> iterator = MapTileModuleProviderBase.this.mPending.keySet().iterator();
                    while (result == null && iterator.hasNext()) {
                        MapTile tile = iterator.next();
                        if (MapTileModuleProviderBase.this.mWorking.containsKey(tile)) continue;
                        result = tile;
                    }
                    if (result != null) {
                        MapTileRequestState state = MapTileModuleProviderBase.this.mPending.get(result);
                        MapTileModuleProviderBase.this.removeTileFromQueues(result);
                        state.getCallback().mapTileRequestFailed(state);
                    }
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapTileAsync(MapTileRequestState pState) {
        if (this.mExecutor.isShutdown()) {
            return;
        }
        Object object = this.mQueueLockObject;
        synchronized (object) {
            this.mPending.put(pState.getMapTile(), pState);
        }
        try {
            this.mExecutor.execute(this.getTileLoader());
        }
        catch (RejectedExecutionException e) {
            Log.w((String)"OsmDroid", (String)"RejectedExecutionException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue() {
        Object object = this.mQueueLockObject;
        synchronized (object) {
            this.mPending.clear();
            this.mWorking.clear();
        }
    }

    public void detach() {
        this.clearQueue();
        this.mExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTileFromQueues(MapTile mapTile) {
        Object object = this.mQueueLockObject;
        synchronized (object) {
            this.mPending.remove(mapTile);
            this.mWorking.remove(mapTile);
        }
    }

    public class CantContinueException
    extends Exception {
        private static final long serialVersionUID = 146526524087765133L;

        public CantContinueException(String pDetailMessage) {
            super(pDetailMessage);
        }

        public CantContinueException(Throwable pThrowable) {
            super(pThrowable);
        }
    }

    protected abstract class TileLoader
    implements Runnable {
        protected TileLoader() {
        }

        protected abstract Drawable loadTile(MapTileRequestState var1) throws CantContinueException;

        protected void onTileLoaderInit() {
        }

        protected void onTileLoaderShutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MapTileRequestState nextTile() {
            Object object = MapTileModuleProviderBase.this.mQueueLockObject;
            synchronized (object) {
                MapTile result = null;
                for (MapTile tile : MapTileModuleProviderBase.this.mPending.keySet()) {
                    if (MapTileModuleProviderBase.this.mWorking.containsKey(tile)) continue;
                    result = tile;
                }
                if (result != null) {
                    MapTileModuleProviderBase.this.mWorking.put(result, MapTileModuleProviderBase.this.mPending.get(result));
                }
                return result != null ? MapTileModuleProviderBase.this.mPending.get(result) : null;
            }
        }

        protected void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestCompleted(pState, pDrawable);
        }

        protected void tileLoadedExpired(MapTileRequestState pState, Drawable pDrawable) {
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestExpiredTile(pState, pDrawable);
        }

        protected void tileLoadedFailed(MapTileRequestState pState) {
            MapTileModuleProviderBase.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestFailed(pState);
        }

        @Override
        public final void run() {
            MapTileRequestState state;
            this.onTileLoaderInit();
            Drawable result = null;
            while ((state = this.nextTile()) != null) {
                try {
                    result = null;
                    result = this.loadTile(state);
                }
                catch (CantContinueException e) {
                    Log.i((String)"OsmDroid", (String)("Tile loader can't continue: " + state.getMapTile()), (Throwable)e);
                    MapTileModuleProviderBase.this.clearQueue();
                }
                catch (Throwable e) {
                    Log.i((String)"OsmDroid", (String)("Error downloading tile: " + state.getMapTile()), (Throwable)e);
                }
                if (result == null) {
                    this.tileLoadedFailed(state);
                    continue;
                }
                if (ExpirableBitmapDrawable.isDrawableExpired(result)) {
                    this.tileLoadedExpired(state, result);
                    continue;
                }
                this.tileLoaded(state, result);
            }
            this.onTileLoaderShutdown();
        }
    }
}

