/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseFileArchive
implements IArchiveFile {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseFileArchive.class);
    private final SQLiteDatabase mDatabase;

    private DatabaseFileArchive(SQLiteDatabase pDatabase) {
        this.mDatabase = pDatabase;
    }

    public static DatabaseFileArchive getDatabaseFileArchive(File pFile) throws SQLiteException {
        return new DatabaseFileArchive(SQLiteDatabase.openOrCreateDatabase((File)pFile, null));
    }

    @Override
    public InputStream getInputStream(ITileSource pTileSource, MapTile pTile) {
        try {
            ByteArrayInputStream ret = null;
            String[] tile = new String[]{"tile"};
            long x = pTile.getX();
            long y = pTile.getY();
            long z = pTile.getZoomLevel();
            long index = ((z << (int)z) + x << (int)z) + y;
            Cursor cur = this.mDatabase.query("tiles", tile, "key = " + index + " and provider = '" + pTileSource.name() + "'", null, null, null, null);
            if (cur.getCount() != 0) {
                cur.moveToFirst();
                ret = new ByteArrayInputStream(cur.getBlob(0));
            }
            cur.close();
            if (ret != null) {
                return ret;
            }
        }
        catch (Throwable e) {
            logger.warn("Error getting db stream: " + pTile, e);
        }
        return null;
    }

    @Override
    public void close() {
        this.mDatabase.close();
    }

    public String toString() {
        return "DatabaseFileArchive [mDatabase=" + this.mDatabase.getPath() + "]";
    }
}

