/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.mylocation;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.location.Location;
import android.util.FloatMath;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import java.util.LinkedList;
import microsoft.mappoint.TileSystem;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IMapView;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapController;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.SafeDrawOverlay;
import org.osmdroid.views.overlay.mylocation.IMyLocationConsumer;
import org.osmdroid.views.overlay.mylocation.IMyLocationProvider;
import org.osmdroid.views.safecanvas.ISafeCanvas;
import org.osmdroid.views.safecanvas.SafePaint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyLocationNewOverlay
extends SafeDrawOverlay
implements IMyLocationConsumer,
IOverlayMenuProvider,
Overlay.Snappable {
    private static final Logger logger = LoggerFactory.getLogger(MyLocationNewOverlay.class);
    protected final SafePaint mPaint = new SafePaint();
    protected final SafePaint mCirclePaint = new SafePaint();
    protected final Bitmap mPersonBitmap;
    protected final Bitmap mDirectionArrowBitmap;
    protected final MapView mMapView;
    private final MapController mMapController;
    public IMyLocationProvider mMyLocationProvider;
    private final LinkedList<Runnable> mRunOnFirstFix = new LinkedList();
    private final Point mMapCoords = new Point();
    private Location mLocation;
    private boolean mIsLocationEnabled = false;
    protected boolean mIsFollowing = false;
    protected boolean mDrawAccuracyEnabled = true;
    protected final PointF mPersonHotspot;
    protected final float mDirectionArrowCenterX;
    protected final float mDirectionArrowCenterY;
    public static final int MENU_MY_LOCATION = MyLocationNewOverlay.getSafeMenuId();
    private boolean mOptionsMenuEnabled = true;
    private final Matrix mDirectionRotater = new Matrix();
    private final float[] mMatrixValues = new float[9];
    private final Matrix mMatrix = new Matrix();
    private final Rect mMyLocationRect = new Rect();
    private final Rect mMyLocationPreviousRect = new Rect();

    public MyLocationNewOverlay(Context context, IMyLocationProvider myLocationProvider, MapView mapView) {
        this(context, myLocationProvider, mapView, new DefaultResourceProxyImpl(context));
    }

    public MyLocationNewOverlay(Context context, IMyLocationProvider myLocationProvider, MapView mapView, ResourceProxy resourceProxy) {
        super(resourceProxy);
        if (myLocationProvider == null) {
            throw new RuntimeException("You must pass an IMyLocationProvider to enableMyLocation()");
        }
        this.mMyLocationProvider = myLocationProvider;
        this.mMapView = mapView;
        this.mMapController = mapView.getController();
        this.mCirclePaint.setARGB(0, 100, 100, 255);
        this.mCirclePaint.setAntiAlias(true);
        this.mPersonBitmap = this.mResourceProxy.getBitmap(ResourceProxy.bitmap.person);
        this.mDirectionArrowBitmap = this.mResourceProxy.getBitmap(ResourceProxy.bitmap.direction_arrow);
        this.mDirectionArrowCenterX = (float)(this.mDirectionArrowBitmap.getWidth() / 2) - 0.5f;
        this.mDirectionArrowCenterY = (float)(this.mDirectionArrowBitmap.getHeight() / 2) - 0.5f;
        this.mPersonHotspot = new PointF(24.0f * this.mScale + 0.5f, 39.0f * this.mScale + 0.5f);
    }

    public void setDrawAccuracyEnabled(boolean drawAccuracyEnabled) {
        this.mDrawAccuracyEnabled = drawAccuracyEnabled;
    }

    public boolean isDrawAccuracyEnabled() {
        return this.mDrawAccuracyEnabled;
    }

    public IMyLocationProvider getMyLocationProvider() {
        return this.mMyLocationProvider;
    }

    protected void setMyLocationProvider(IMyLocationProvider myLocationProvider) {
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.stopLocationProvider();
        }
        this.mMyLocationProvider = myLocationProvider;
    }

    public void setPersonHotspot(float x, float y) {
        this.mPersonHotspot.set(x, y);
    }

    protected void drawMyLocation(ISafeCanvas canvas, MapView mapView, Location lastFix) {
        MapView.Projection pj = mapView.getProjection();
        int zoomDiff = 22 - pj.getZoomLevel();
        if (this.mDrawAccuracyEnabled) {
            float radius = lastFix.getAccuracy() / (float)TileSystem.GroundResolution(lastFix.getLatitude(), mapView.getZoomLevel());
            this.mCirclePaint.setAlpha(50);
            this.mCirclePaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle(this.mMapCoords.x >> zoomDiff, this.mMapCoords.y >> zoomDiff, radius, this.mCirclePaint);
            this.mCirclePaint.setAlpha(150);
            this.mCirclePaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle(this.mMapCoords.x >> zoomDiff, this.mMapCoords.y >> zoomDiff, radius, this.mCirclePaint);
        }
        canvas.getMatrix(this.mMatrix);
        this.mMatrix.getValues(this.mMatrixValues);
        this.mDirectionRotater.reset();
        if (lastFix.hasBearing()) {
            this.mDirectionRotater.setRotate(lastFix.getBearing(), this.mDirectionArrowCenterX, this.mDirectionArrowCenterY);
            this.mDirectionRotater.postTranslate(-this.mDirectionArrowCenterX, -this.mDirectionArrowCenterY);
            this.mDirectionRotater.postScale(1.0f / this.mMatrixValues[0], 1.0f / this.mMatrixValues[4]);
            this.mDirectionRotater.postTranslate((float)(this.mMapCoords.x >> zoomDiff), (float)(this.mMapCoords.y >> zoomDiff));
            canvas.drawBitmap(this.mDirectionArrowBitmap, this.mDirectionRotater, this.mPaint);
        } else {
            this.mDirectionRotater.setTranslate(-this.mPersonHotspot.x, -this.mPersonHotspot.y);
            this.mDirectionRotater.postScale(1.0f / this.mMatrixValues[0], 1.0f / this.mMatrixValues[4]);
            this.mDirectionRotater.postTranslate((float)(this.mMapCoords.x >> zoomDiff), (float)(this.mMapCoords.y >> zoomDiff));
            canvas.drawBitmap(this.mPersonBitmap, this.mDirectionRotater, this.mPaint);
        }
    }

    protected Rect getMyLocationDrawingBounds(int zoomLevel, Location lastFix, Rect reuse) {
        if (reuse == null) {
            reuse = new Rect();
        }
        int zoomDiff = 22 - zoomLevel;
        int posX = this.mMapCoords.x >> zoomDiff;
        int posY = this.mMapCoords.y >> zoomDiff;
        if (lastFix.hasBearing()) {
            int widestEdge = (int)Math.ceil((double)Math.max(this.mDirectionArrowBitmap.getWidth(), this.mDirectionArrowBitmap.getHeight()) * Math.sqrt(2.0));
            reuse.set(posX, posY, posX + widestEdge, posY + widestEdge);
            reuse.offset(-widestEdge / 2, -widestEdge / 2);
        } else {
            reuse.set(posX, posY, posX + this.mPersonBitmap.getWidth(), posY + this.mPersonBitmap.getHeight());
            reuse.offset((int)(-this.mPersonHotspot.x), (int)(-this.mPersonHotspot.y));
        }
        if (this.mDrawAccuracyEnabled) {
            int radius = (int)FloatMath.ceil((float)(lastFix.getAccuracy() / (float)TileSystem.GroundResolution(lastFix.getLatitude(), zoomLevel)));
            reuse.union(posX - radius, posY - radius, posX + radius, posY + radius);
            int strokeWidth = (int)FloatMath.ceil((float)(this.mCirclePaint.getStrokeWidth() == 0.0f ? 1.0f : this.mCirclePaint.getStrokeWidth()));
            reuse.inset(-strokeWidth, -strokeWidth);
        }
        reuse.offset(this.mMapView.getWidth() / 2, this.mMapView.getHeight() / 2);
        return reuse;
    }

    @Override
    protected void drawSafe(ISafeCanvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mLocation != null) {
            this.drawMyLocation(canvas, mapView, this.mLocation);
        }
    }

    @Override
    public boolean onSnapToItem(int x, int y, Point snapPoint, IMapView mapView) {
        if (this.mLocation != null) {
            snapPoint.x = this.mMapCoords.x;
            snapPoint.y = this.mMapCoords.y;
            double xDiff = x - this.mMapCoords.x;
            double yDiff = y - this.mMapCoords.y;
            boolean snap = xDiff * xDiff + yDiff * yDiff < 64.0;
            return snap;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (event.getAction() == 2) {
            this.disableFollowLocation();
        }
        return super.onTouchEvent(event, mapView);
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_MY_LOCATION + pMenuIdOffset, 0, (CharSequence)this.mResourceProxy.getString(ResourceProxy.string.my_location)).setIcon(this.mResourceProxy.getDrawable(ResourceProxy.bitmap.ic_menu_mylocation));
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId == MENU_MY_LOCATION) {
            if (this.isMyLocationEnabled()) {
                this.disableFollowLocation();
                this.disableMyLocation();
            } else {
                this.enableFollowLocation();
                this.enableMyLocation(this.getMyLocationProvider());
            }
            return true;
        }
        return false;
    }

    public GeoPoint getMyLocation() {
        if (this.mLocation == null) {
            return null;
        }
        return new GeoPoint(this.mLocation);
    }

    public Location getLastFix() {
        return this.mLocation;
    }

    public void enableFollowLocation() {
        this.mIsFollowing = true;
        if (this.isMyLocationEnabled()) {
            this.mLocation = this.mMyLocationProvider.getLastKnownLocation();
            if (this.mLocation != null) {
                TileSystem.LatLongToPixelXY(this.mLocation.getLatitude(), this.mLocation.getLongitude(), 22, this.mMapCoords);
                int worldSize_2 = TileSystem.MapSize(22) / 2;
                this.mMapCoords.offset(-worldSize_2, -worldSize_2);
                this.mMapController.animateTo(new GeoPoint(this.mLocation));
            }
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    public void disableFollowLocation() {
        this.mIsFollowing = false;
    }

    public boolean isFollowLocationEnabled() {
        return this.mIsFollowing;
    }

    @Override
    public void onLocationChanged(Location location, IMyLocationProvider source) {
        Location oldLocation = this.mLocation;
        if (oldLocation != null) {
            this.getMyLocationDrawingBounds(this.mMapView.getZoomLevel(), oldLocation, this.mMyLocationPreviousRect);
        }
        this.mLocation = location;
        this.mMapCoords.set(0, 0);
        if (this.mLocation != null) {
            TileSystem.LatLongToPixelXY(this.mLocation.getLatitude(), this.mLocation.getLongitude(), 22, this.mMapCoords);
            int worldSize_2 = TileSystem.MapSize(22) / 2;
            this.mMapCoords.offset(-worldSize_2, -worldSize_2);
            if (this.mIsFollowing) {
                this.mMapController.animateTo(this.mLocation.getLatitude(), this.mLocation.getLongitude());
            } else {
                this.getMyLocationDrawingBounds(this.mMapView.getZoomLevel(), this.mLocation, this.mMyLocationRect);
                if (oldLocation != null) {
                    this.mMyLocationRect.union(this.mMyLocationPreviousRect);
                }
                this.mMapView.postInvalidate(this.mMyLocationRect.left, this.mMyLocationRect.top, this.mMyLocationRect.right, this.mMyLocationRect.bottom);
            }
        }
        for (Runnable runnable : this.mRunOnFirstFix) {
            new Thread(runnable).start();
        }
        this.mRunOnFirstFix.clear();
    }

    public boolean enableMyLocation(IMyLocationProvider myLocationProvider) {
        boolean result = true;
        if (myLocationProvider == null) {
            throw new RuntimeException("You must pass an IMyLocationProvider to enableMyLocation()");
        }
        this.setMyLocationProvider(myLocationProvider);
        this.mIsLocationEnabled = result = this.mMyLocationProvider.startLocationProvider(this);
        if (result && this.isFollowLocationEnabled()) {
            this.mLocation = this.mMyLocationProvider.getLastKnownLocation();
            if (this.mLocation != null) {
                TileSystem.LatLongToPixelXY(this.mLocation.getLatitude(), this.mLocation.getLongitude(), 22, this.mMapCoords);
                int worldSize_2 = TileSystem.MapSize(22) / 2;
                this.mMapCoords.offset(-worldSize_2, -worldSize_2);
                this.mMapController.animateTo(new GeoPoint(this.mLocation));
            }
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
        return result;
    }

    public void disableMyLocation() {
        this.mIsLocationEnabled = false;
        if (this.mMyLocationProvider != null) {
            this.mMyLocationProvider.stopLocationProvider();
        }
        if (this.mMapView != null) {
            this.mMapView.postInvalidate();
        }
    }

    public boolean isMyLocationEnabled() {
        return this.mIsLocationEnabled;
    }

    public boolean runOnFirstFix(Runnable runnable) {
        if (this.mMyLocationProvider != null && this.mLocation != null) {
            new Thread(runnable).start();
            return true;
        }
        this.mRunOnFirstFix.addLast(runnable);
        return false;
    }
}

