/*
 * Decompiled with CFR 0.152.
 */
package net.wigle.wigleandroid;

import android.view.MotionEvent;
import android.view.View;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomButtonsController {
    private static final Logger logger = LoggerFactory.getLogger(ZoomButtonsController.class);
    private static Class ZOOM_CLASS;
    private static Class LISTENER_CLASS;
    private static Method setOnZoomListener;
    private static Method setVisible;
    private static Method setZoomInEnabled;
    private static Method setZoomOutEnabled;
    private static Method onTouch;
    private static Method isVisible;
    private Object controller;

    public ZoomButtonsController(View view) {
        if (ZOOM_CLASS != null) {
            try {
                this.controller = ZOOM_CLASS.getConstructor(View.class).newInstance(view);
            }
            catch (Exception ex) {
                logger.error("exception instantiating: " + ex);
            }
        }
    }

    public void setOnZoomListener(final OnZoomListener listener) {
        if (this.controller != null) {
            try {
                InvocationHandler handler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object object, Method method, Object[] args) {
                        logger.info("invoke: " + method.getName() + " listener: " + listener);
                        if ("onZoom".equals(method.getName())) {
                            listener.onZoom((Boolean)args[0]);
                        } else if ("onVisibilityChanged".equals(method.getName())) {
                            listener.onVisibilityChanged((Boolean)args[0]);
                        } else {
                            logger.info("unhandled listener method: " + method);
                        }
                        return null;
                    }
                };
                Object proxy = Proxy.newProxyInstance(LISTENER_CLASS.getClassLoader(), new Class[]{LISTENER_CLASS}, handler);
                setOnZoomListener.invoke(this.controller, proxy);
            }
            catch (Exception ex) {
                logger.error("setOnZoomListener exception: " + ex);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.controller != null) {
            try {
                setVisible.invoke(this.controller, visible);
            }
            catch (Exception ex) {
                logger.error("setVisible exception: " + ex);
            }
        }
    }

    public void setZoomInEnabled(boolean enabled) {
        if (this.controller != null) {
            try {
                setZoomInEnabled.invoke(this.controller, enabled);
            }
            catch (Exception ex) {
                logger.error("setZoomInEnabled exception: " + ex);
            }
        }
    }

    public void setZoomOutEnabled(boolean enabled) {
        if (this.controller != null) {
            try {
                setZoomOutEnabled.invoke(this.controller, enabled);
            }
            catch (Exception ex) {
                logger.error("setZoomOutEnabled exception: " + ex);
            }
        }
    }

    public boolean onTouch(View v, MotionEvent m) {
        if (this.controller != null) {
            try {
                return (Boolean)onTouch.invoke(this.controller, v, m);
            }
            catch (Exception ex) {
                logger.error("onTouch exception: " + ex);
            }
        }
        return false;
    }

    public boolean isVisible() {
        if (this.controller != null) {
            try {
                return (Boolean)isVisible.invoke(this.controller, new Object[0]);
            }
            catch (Exception ex) {
                logger.error("isVisible exception: " + ex);
            }
        }
        return false;
    }

    static {
        try {
            ZOOM_CLASS = Class.forName("android.widget.ZoomButtonsController");
            for (Class<?> clazz : ZOOM_CLASS.getDeclaredClasses()) {
                if (!"OnZoomListener".equals(clazz.getSimpleName())) continue;
                LISTENER_CLASS = clazz;
            }
            setOnZoomListener = ZOOM_CLASS.getMethod("setOnZoomListener", LISTENER_CLASS);
            setVisible = ZOOM_CLASS.getMethod("setVisible", Boolean.TYPE);
            setZoomInEnabled = ZOOM_CLASS.getMethod("setZoomInEnabled", Boolean.TYPE);
            setZoomOutEnabled = ZOOM_CLASS.getMethod("setZoomOutEnabled", Boolean.TYPE);
            onTouch = ZOOM_CLASS.getMethod("onTouch", View.class, MotionEvent.class);
            isVisible = ZOOM_CLASS.getMethod("isVisible", new Class[0]);
        }
        catch (Exception ex) {
            logger.info("no zoom buttons: " + ex);
        }
    }

    public static interface OnZoomListener {
        public void onZoom(boolean var1);

        public void onVisibilityChanged(boolean var1);
    }
}

