/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.drawable.Drawable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osmdroid.tileprovider.LRUMapTileCache;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;

public final class MapTileCache
implements OpenStreetMapTileProviderConstants {
    protected LRUMapTileCache mCachedTiles;
    private final ReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();

    public MapTileCache() {
        this(9);
    }

    public MapTileCache(int aMaximumCacheSize) {
        this.mCachedTiles = new LRUMapTileCache(aMaximumCacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int aCapacity) {
        this.mReadWriteLock.readLock().lock();
        try {
            this.mCachedTiles.ensureCapacity(aCapacity);
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getMapTile(MapTile aTile) {
        this.mReadWriteLock.readLock().lock();
        try {
            Drawable drawable = (Drawable)this.mCachedTiles.get(aTile);
            return drawable;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTile(MapTile aTile, Drawable aDrawable) {
        if (aDrawable != null) {
            this.mReadWriteLock.writeLock().lock();
            try {
                this.mCachedTiles.put(aTile, aDrawable);
            }
            finally {
                this.mReadWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTile(MapTile aTile) {
        this.mReadWriteLock.readLock().lock();
        try {
            boolean bl = this.mCachedTiles.containsKey(aTile);
            return bl;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.mReadWriteLock.writeLock().lock();
        try {
            this.mCachedTiles.clear();
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }
}

