/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.events;

import android.os.Handler;
import org.osmdroid.events.MapEvent;
import org.osmdroid.events.MapListener;
import org.osmdroid.events.ScrollEvent;
import org.osmdroid.events.ZoomEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedMapListener
implements MapListener {
    private static final Logger logger = LoggerFactory.getLogger(DelayedMapListener.class);
    protected static final int DEFAULT_DELAY = 100;
    MapListener wrappedListener;
    protected long delay;
    protected Handler handler;
    protected CallbackTask callback;

    public DelayedMapListener(MapListener wrappedListener, long delay) {
        this.wrappedListener = wrappedListener;
        this.delay = delay;
        this.handler = new Handler();
        this.callback = null;
    }

    public DelayedMapListener(MapListener wrappedListener) {
        this(wrappedListener, 100L);
    }

    @Override
    public boolean onScroll(ScrollEvent event) {
        this.dispatch(event);
        return true;
    }

    @Override
    public boolean onZoom(ZoomEvent event) {
        this.dispatch(event);
        return true;
    }

    protected void dispatch(MapEvent event) {
        if (this.callback != null) {
            this.handler.removeCallbacks((Runnable)this.callback);
        }
        this.callback = new CallbackTask(event);
        this.handler.postDelayed((Runnable)this.callback, this.delay);
    }

    private class CallbackTask
    implements Runnable {
        private final MapEvent event;

        public CallbackTask(MapEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (this.event instanceof ScrollEvent) {
                DelayedMapListener.this.wrappedListener.onScroll((ScrollEvent)this.event);
            } else if (this.event instanceof ZoomEvent) {
                DelayedMapListener.this.wrappedListener.onZoom((ZoomEvent)this.event);
            } else {
                logger.debug("Unknown event received: " + this.event);
            }
        }
    }
}

