/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.model;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.javanetworkanalyzer.data.VId;
import org.javanetworkanalyzer.model.DirectedG;
import org.javanetworkanalyzer.model.EdgeID;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.ClassBasedEdgeFactory;
import org.jgrapht.graph.DirectedPseudograph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectedPseudoG<V extends VId, E extends EdgeID>
extends DirectedPseudograph<V, E>
implements DirectedG<V, E> {
    private final Map<Integer, V> nodeMap = new HashMap<Integer, V>();
    private Constructor<? extends V> vConstructor;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectedPseudoG.class);

    public DirectedPseudoG(Class<? extends V> vertexClass, Class<? extends E> edgeClass) {
        this(vertexClass, (EdgeFactory<? extends V, E>)new ClassBasedEdgeFactory(edgeClass));
    }

    public DirectedPseudoG(Class<? extends V> vertexClass, EdgeFactory<V, E> ef) {
        super(ef);
        try {
            this.vConstructor = vertexClass.getConstructor(Integer.class);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.error("The vertex must have a V(Integer) constructor.", (Throwable)ex);
        }
        catch (SecurityException ex) {
            LOGGER.trace(ex.toString());
        }
    }

    @Override
    public boolean addVertex(int id) {
        if (!this.nodeMap.containsKey(id)) {
            try {
                VId node = (VId)this.vConstructor.newInstance(id);
                this.nodeMap.put(id, node);
                return this.addVertex(node);
            }
            catch (Exception ex) {
                return false;
            }
        }
        throw new IllegalStateException("This vertex has already been added!");
    }

    @Override
    public V getVertex(int id) {
        return (V)((VId)this.nodeMap.get(id));
    }

    @Override
    public E addEdge(int source, int target, int edgeID) {
        if (!this.containsVertex(this.getVertex(source))) {
            this.addVertex(source);
        }
        if (!this.containsVertex(this.getVertex(target))) {
            this.addVertex(target);
        }
        EdgeID e = (EdgeID)this.addEdge(this.getVertex(source), this.getVertex(target));
        e.setID(edgeID);
        return (E)e;
    }

    @Override
    public E addEdge(int source, int target) {
        return this.addEdge(source, target, -1);
    }
}

