/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine.jvm;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.ifcengine.jvm.IfcEngineInterface;
import org.bimserver.ifcengine.jvm.RenderEngineInstanceVisualisationPropertiesInternal;
import org.bimserver.ifcengine.jvm.SdaiTypes;
import org.bimserver.plugins.renderengine.RenderEngineClash;

public class IfcEngine {
    public static final int D3DFVF_XYZ = 2;
    public static final int D3DFVF_XYZRHW = 4;
    public static final int D3DFVF_NORMAL = 16;
    public static final int D3DFVF_PSIZE = 32;
    public static final int D3DFVF_DIFFUSE = 64;
    public static final int D3DFVF_SPECULAR = 128;
    public static final int D3DFVF_TEX1 = 256;
    private final Set<IfcEngineInterface.StreamCallback> callBacks = new HashSet<IfcEngineInterface.StreamCallback>();
    private final IfcEngineInterface engine = IfcEngineInterface.INSTANCE;

    public Pointer loadFromInputStream(final InputStream in, final int size, String schemaName) {
        final byte[] buffer = new byte[1024];
        IfcEngineInterface.StreamCallback fn = new IfcEngineInterface.StreamCallback(){
            int total = 0;

            @Override
            public int invoke(Pointer pointer) {
                if (this.total == size) {
                    return -1;
                }
                ByteBuffer byteBuffer = pointer.getByteBuffer(0L, 1024L);
                try {
                    int read = in.read(buffer, 0, Math.min(1024, size - this.total));
                    if (read == -1) {
                        return -1;
                    }
                    this.total += read;
                    byteBuffer.put(buffer, 0, read);
                    return read;
                }
                catch (IOException iOException) {
                    return -1;
                }
            }
        };
        this.callBacks.add(fn);
        return this.engine.xxxxOpenModelByStream(0, fn, schemaName);
    }

    public Pointer loadFromInputStream(final InputStream in, String schemaName) {
        final byte[] buffer = new byte[1024];
        IfcEngineInterface.StreamCallback fn = new IfcEngineInterface.StreamCallback(){

            @Override
            public int invoke(Pointer pointer) {
                try {
                    int read = in.read(buffer, 0, 1024);
                    if (read == -1) {
                        return -1;
                    }
                    ByteBuffer byteBuffer = pointer.getByteBuffer(0L, (long)read);
                    byteBuffer.put(buffer, 0, read);
                    return read;
                }
                catch (IOException iOException) {
                    return -1;
                }
            }
        };
        this.callBacks.add(fn);
        return this.engine.xxxxOpenModelByStream(0, fn, schemaName);
    }

    public void circleSegments(int circles, int smallCircles) {
        this.engine.circleSegments(circles, smallCircles);
    }

    public void setFormat(Pointer modelId, int format, int mask) {
        this.engine.setFormat(modelId, format, mask);
    }

    public void setFilter(Pointer modelId, int format, int mask) {
        this.engine.setFilter(modelId, format, mask);
    }

    public Object engiGetAggrElement(Pointer aggregate, int elementIndex, SdaiTypes valueType) {
        Object returnValue = null;
        switch (valueType) {
            case INTEGER: {
                IntByReference intRef = new IntByReference();
                this.engine.engiGetAggrElement(aggregate, elementIndex, valueType.ordinal(), intRef);
                returnValue = new Integer(intRef.getValue());
                break;
            }
            case REAL: {
                DoubleByReference dblRef = new DoubleByReference();
                this.engine.engiGetAggrElement(aggregate, elementIndex, valueType.ordinal(), dblRef);
                returnValue = new Double(dblRef.getValue());
                break;
            }
            case STRING: {
                PointerByReference strRef = new PointerByReference();
                this.engine.engiGetAggrElement(aggregate, elementIndex, valueType.ordinal(), strRef);
                Pointer strPtr = strRef.getValue();
                if (strPtr == null) break;
                returnValue = strPtr.getString(0L);
                break;
            }
            default: {
                PointerByReference ptrRef = new PointerByReference();
                this.engine.engiGetAggrElement(aggregate, elementIndex, valueType.ordinal(), ptrRef);
                returnValue = ptrRef.getValue();
            }
        }
        return returnValue;
    }

    public String engiGetInstanceClassInfo(Pointer instance) {
        return this.engine.engiGetInstanceClassInfo(instance);
    }

    public String engiGetInstanceClassInfoUC(Pointer instance) {
        return this.engine.engiGetInstanceClassInfoUC(instance);
    }

    public int engiGetInstanceLocalId(Pointer instance) {
        return this.engine.engiGetInstanceLocalId(instance);
    }

    public int engiGetInstanceMetaInfo(Pointer instance, String className, String classNameUC) {
        IntByReference localIdRef = new IntByReference();
        PointerByReference classNameRef = new PointerByReference();
        PointerByReference classNameUCRef = new PointerByReference();
        this.engine.engiGetInstanceMetaInfo(instance, localIdRef, classNameRef, classNameUCRef);
        className = classNameRef.getValue().getString(0L);
        classNameUC = classNameUCRef.getValue().getString(0L);
        return localIdRef.getValue();
    }

    private int getPlatformMultiplier() {
        return System.getProperty("sun.arch.data.model").equals("32") ? 1 : 2;
    }

    public Set<RenderEngineClash> finalizeClashesByEI(Pointer modelId, int size) {
        HashSet<RenderEngineClash> clashes = new HashSet<RenderEngineClash>();
        Memory pG1 = new Memory((long)(size * 4 * this.getPlatformMultiplier()));
        Memory pG2 = new Memory((long)(size * 4 * this.getPlatformMultiplier()));
        this.engine.finalizeClashesByEI(modelId, (Pointer)pG1, (Pointer)pG2);
        for (int i = 0; i < size; ++i) {
            Long eid1 = null;
            Long eid2 = null;
            if (this.getPlatformMultiplier() == 1) {
                eid1 = pG1.getInt((long)(i * 4 * this.getPlatformMultiplier()));
                eid2 = pG2.getInt((long)(i * 4 * this.getPlatformMultiplier()));
            } else {
                eid1 = pG1.getLong((long)(i * 4 * this.getPlatformMultiplier()));
                eid2 = pG2.getLong((long)(i * 4 * this.getPlatformMultiplier()));
            }
            RenderEngineClash clash = new RenderEngineClash();
            clash.setEid1(eid1.longValue());
            clash.setEid2(eid2.longValue());
            clashes.add(clash);
        }
        return clashes;
    }

    public Set<RenderEngineClash> finalizeClashesByGuid(Pointer modelId, int size) {
        HashSet<RenderEngineClash> clashes = new HashSet<RenderEngineClash>();
        Memory pG1 = new Memory((long)(size * 4 * this.getPlatformMultiplier()));
        Memory pG2 = new Memory((long)(size * 4 * this.getPlatformMultiplier()));
        this.engine.finalizeClashesByGuid(modelId, (Pointer)pG1, (Pointer)pG2);
        for (int i = 0; i < size; ++i) {
            Pointer memory1 = pG1.getPointer((long)(i * 4 * this.getPlatformMultiplier()));
            String pG1Str = memory1.getString(0L);
            Pointer memory2 = pG2.getPointer((long)(i * 4 * this.getPlatformMultiplier()));
            String pG2Str = memory2.getString(0L);
            RenderEngineClash clash = new RenderEngineClash();
            clash.setGuid1(pG1Str);
            clash.setGuid2(pG2Str);
            clashes.add(clash);
        }
        return clashes;
    }

    public SurfaceProperties initializeModellingInstance(Pointer model, double scale, Pointer instance) {
        IntByReference pV = new IntByReference();
        IntByReference pI = new IntByReference();
        this.engine.initializeModellingInstance(model, pV, pI, scale, instance);
        int noVertices = pV.getValue();
        int noIndices = pI.getValue();
        return new SurfaceProperties(model, instance, noVertices, noIndices, scale);
    }

    public SurfaceProperties initializeModellingInstanceEx(Pointer model, double scale, Pointer instance, Pointer instanceList) {
        IntByReference pV = new IntByReference();
        IntByReference pI = new IntByReference();
        this.engine.initializeModellingInstanceEx(model, pV, pI, scale, instance, instanceList);
        int noVertices = pV.getValue();
        int noIndices = pI.getValue();
        return new SurfaceProperties(model, instance, instanceList, noVertices, noIndices, scale);
    }

    public int finalizeModelling(Pointer model, float[] coordinates, float[] normals, int[] indices) {
        int i;
        int fvf = 0;
        int size = 0;
        int noVertices = 0;
        int noIndices = 0;
        if (coordinates != null) {
            fvf |= 2;
            size += 3;
            noVertices = coordinates.length / 3;
        }
        if (normals != null) {
            fvf |= 0x10;
            size += 3;
        }
        if (indices != null) {
            noIndices = indices.length;
        }
        Memory pV = new Memory((long)(noVertices * size * 4 * this.getPlatformMultiplier()));
        Memory pI = new Memory((long)(noIndices * 4 * this.getPlatformMultiplier()));
        int finalizeModelling = this.engine.finalizeModelling(model, (Pointer)pV, (Pointer)pI, fvf);
        for (i = 0; i < noVertices * size; i += size) {
            int j;
            int p = i;
            if ((fvf & 2) != 0) {
                for (j = 0; j < 3; ++j) {
                    coordinates[i / 2 + j] = pV.getFloat((long)(p * 4));
                    ++p;
                }
            }
            if ((fvf & 0x10) == 0) continue;
            for (j = 0; j < 3; ++j) {
                normals[i / 2 + j] = pV.getFloat((long)(p * 4));
                ++p;
            }
        }
        for (i = 0; i < noIndices; ++i) {
            indices[i] = pI.getInt((long)(i * 4));
        }
        return finalizeModelling;
    }

    public RenderEngineInstanceVisualisationPropertiesInternal getInstanceInModelling(Pointer model, Pointer instance, int mode) {
        IntByReference pV = new IntByReference();
        IntByReference pI = new IntByReference();
        IntByReference pC = new IntByReference();
        this.engine.getInstanceInModelling(model, instance, mode, pV, pI, pC);
        int startVertex = pV.getValue();
        int startIndex = pI.getValue();
        int primitiveCount = pC.getValue();
        return new RenderEngineInstanceVisualisationPropertiesInternal(startVertex, startIndex, primitiveCount);
    }

    public int getTimeStamp(Pointer model) {
        return this.engine.getTimeStamp(model);
    }

    public String getChangedData(Pointer model, int timeStamp) {
        return this.engine.getChangedData(model, timeStamp);
    }

    public void setChangedData(Pointer model, int timeStamp, String changedData) {
        this.engine.setChangedData(model, timeStamp, changedData);
    }

    public int setStringUnicode(boolean unicode) {
        return this.engine.setStringUnicode(unicode);
    }

    public InstanceDerivedProperties getInstanceDerivedPropertiesInModelling(int model, Pointer instance) {
        DoubleByReference pH = new DoubleByReference();
        DoubleByReference pW = new DoubleByReference();
        DoubleByReference pT = new DoubleByReference();
        this.engine.getInstanceDerivedPropertiesInModelling(model, instance, pH, pW, pT);
        double height = pH.getValue();
        double width = pW.getValue();
        double thickness = pT.getValue();
        return new InstanceDerivedProperties(model, instance, height, width, thickness);
    }

    public InstanceDerivedBoundingBox getInstanceDerivedBoundingBox(Pointer model, Pointer instance) {
        DoubleByReference pOx = new DoubleByReference();
        DoubleByReference pOy = new DoubleByReference();
        DoubleByReference pOz = new DoubleByReference();
        DoubleByReference pVx = new DoubleByReference();
        DoubleByReference pVy = new DoubleByReference();
        DoubleByReference pVz = new DoubleByReference();
        this.engine._getInstanceDerivedBoundingBox(model, instance, pOx, pOy, pOz, pVx, pVy, pVz);
        double ox = pOx.getValue();
        double oy = pOy.getValue();
        double oz = pOz.getValue();
        double vx = pVx.getValue();
        double vy = pVy.getValue();
        double vz = pVz.getValue();
        return new InstanceDerivedBoundingBox(model, instance, ox, oy, oz, vx, vy, vz);
    }

    public InstanceDerivedTransformationMatrix getInstanceDerivedTransformationMatrix(Pointer model, Pointer instance) {
        DoubleByReference p_11 = new DoubleByReference();
        DoubleByReference p_12 = new DoubleByReference();
        DoubleByReference p_13 = new DoubleByReference();
        DoubleByReference p_14 = new DoubleByReference();
        DoubleByReference p_21 = new DoubleByReference();
        DoubleByReference p_22 = new DoubleByReference();
        DoubleByReference p_23 = new DoubleByReference();
        DoubleByReference p_24 = new DoubleByReference();
        DoubleByReference p_31 = new DoubleByReference();
        DoubleByReference p_32 = new DoubleByReference();
        DoubleByReference p_33 = new DoubleByReference();
        DoubleByReference p_34 = new DoubleByReference();
        DoubleByReference p_41 = new DoubleByReference();
        DoubleByReference p_42 = new DoubleByReference();
        DoubleByReference p_43 = new DoubleByReference();
        DoubleByReference p_44 = new DoubleByReference();
        this.engine.getInstanceDerivedTransformationMatrix(model, instance, p_11, p_12, p_13, p_14, p_21, p_22, p_23, p_24, p_31, p_32, p_33, p_34, p_41, p_42, p_43, p_44);
        double _11 = p_11.getValue();
        double _12 = p_12.getValue();
        double _13 = p_13.getValue();
        double _14 = p_14.getValue();
        double _21 = p_21.getValue();
        double _22 = p_22.getValue();
        double _23 = p_23.getValue();
        double _24 = p_24.getValue();
        double _31 = p_31.getValue();
        double _32 = p_32.getValue();
        double _33 = p_33.getValue();
        double _34 = p_34.getValue();
        double _41 = p_41.getValue();
        double _42 = p_42.getValue();
        double _43 = p_43.getValue();
        double _44 = p_44.getValue();
        return new InstanceDerivedTransformationMatrix(model, instance, _11, _12, _13, _14, _21, _22, _23, _24, _31, _32, _33, _34, _41, _42, _43, _44);
    }

    public InstanceTransformationMatrix getInstanceTransformationMatrix(Pointer model, Pointer instance) {
        DoubleByReference p_11 = new DoubleByReference();
        DoubleByReference p_12 = new DoubleByReference();
        DoubleByReference p_13 = new DoubleByReference();
        DoubleByReference p_14 = new DoubleByReference();
        DoubleByReference p_21 = new DoubleByReference();
        DoubleByReference p_22 = new DoubleByReference();
        DoubleByReference p_23 = new DoubleByReference();
        DoubleByReference p_24 = new DoubleByReference();
        DoubleByReference p_31 = new DoubleByReference();
        DoubleByReference p_32 = new DoubleByReference();
        DoubleByReference p_33 = new DoubleByReference();
        DoubleByReference p_34 = new DoubleByReference();
        DoubleByReference p_41 = new DoubleByReference();
        DoubleByReference p_42 = new DoubleByReference();
        DoubleByReference p_43 = new DoubleByReference();
        DoubleByReference p_44 = new DoubleByReference();
        this.engine.getInstanceDerivedTransformationMatrix(model, instance, p_11, p_12, p_13, p_14, p_21, p_22, p_23, p_24, p_31, p_32, p_33, p_34, p_41, p_42, p_43, p_44);
        double _11 = p_11.getValue();
        double _12 = p_12.getValue();
        double _13 = p_13.getValue();
        double _14 = p_14.getValue();
        double _21 = p_21.getValue();
        double _22 = p_22.getValue();
        double _23 = p_23.getValue();
        double _24 = p_24.getValue();
        double _31 = p_31.getValue();
        double _32 = p_32.getValue();
        double _33 = p_33.getValue();
        double _34 = p_34.getValue();
        double _41 = p_41.getValue();
        double _42 = p_42.getValue();
        double _43 = p_43.getValue();
        double _44 = p_44.getValue();
        return new InstanceTransformationMatrix(model, instance, _11, _12, _13, _14, _21, _22, _23, _24, _31, _32, _33, _34, _41, _42, _43, _44);
    }

    public Pointer internalGetBoundingBox(Pointer model, Pointer instance) {
        return this.engine.internalGetBoundingBox(model, instance);
    }

    public Pointer internalGetCenter(Pointer model, Pointer instance) throws Exception {
        return this.engine.internalGetCenter(model, instance);
    }

    public void internalSetLink(Pointer instance, String attributeName, int linked_id) {
        this.engine.internalSetLink(instance, attributeName, linked_id);
    }

    public void internalAddAggrLink(int list, int linked_id) {
        this.engine.internalAddAggrLink(list, linked_id);
    }

    public int sdaiGetAggregationAttrBN(Pointer instance, String attributeName) {
        return this.engine.sdaiGetAggregationAttrBN(instance, attributeName);
    }

    public Object sdaiGetAttrBN(Pointer instance, String attributeName, SdaiTypes valueType) {
        PointerByReference ptrRef = new PointerByReference();
        this.engine.sdaiGetAttrBN(instance, attributeName, valueType.ordinal(), ptrRef);
        switch (valueType) {
            case STRING: {
                return ptrRef.getValue().getString(0L);
            }
        }
        return ptrRef.getValue();
    }

    public Pointer sdaiGetEntity(Pointer model, String entityName) {
        return this.engine.sdaiGetEntity(model, entityName);
    }

    public Pointer sdaiGetEntityExtentBN(Pointer model, String entityName) {
        return this.engine.sdaiGetEntityExtentBN(model, entityName);
    }

    public int sdaiGetInstanceAttrBN(Pointer instance, String attributeName) {
        return this.engine.sdaiGetInstanceAttrBN(instance, attributeName);
    }

    public Pointer sdaiGetInstanceType(Pointer instance) {
        return this.engine.sdaiGetInstanceType(instance);
    }

    public int sdaiGetMemberCount(Pointer aggregate) {
        return this.engine.sdaiGetMemberCount(aggregate);
    }

    public String sdaiGetStringAttrBN(Pointer instance, String attributeName) {
        return this.engine.sdaiGetStringAttrBN(instance, attributeName);
    }

    public Pointer sdaiOpenModelBN(int repository, String fileName, String schemaName) {
        return this.engine.sdaiOpenModelBN(1, fileName, schemaName);
    }

    public int sdaiCreateModelBN(int repository, String fileName, String schemaName) {
        return this.engine.sdaiCreateModelBN(repository, fileName, schemaName);
    }

    public void sdaiSaveModelBN(int repository, String fileName) {
        this.engine.sdaiSaveModelBN(repository, fileName);
    }

    public void sdaiSaveModelAsXmlBN(Pointer model, String fileName) {
        this.engine.sdaiSaveModelAsXmlBN(model, fileName);
    }

    public void sdaiCloseModel(Pointer model) {
        this.engine.sdaiCloseModel(model);
    }

    public void sdaiAppend(int list, SdaiTypes valueType, Object value) {
        switch (valueType) {
            case INTEGER: 
            case BOOLEAN: 
            case LOGICAL: {
                IntByReference iVal = new IntByReference(((Integer)value).intValue());
                this.engine.sdaiAppend(list, valueType.ordinal(), iVal);
                break;
            }
            case REAL: {
                DoubleByReference dVal = new DoubleByReference(((Double)value).doubleValue());
                this.engine.sdaiAppend(list, valueType.ordinal(), dVal);
                break;
            }
            case STRING: {
                this.engine.sdaiAppend(list, valueType.ordinal(), (String)value);
                break;
            }
            default: {
                this.engine.sdaiAppend(list, valueType.ordinal(), (Pointer)value);
            }
        }
    }

    public void sdaiBeginning(int iterator) throws Exception {
        this.engine.sdaiBeginning(iterator);
    }

    public Pointer sdaiCreateADB(SdaiTypes valueType, Object value) {
        Pointer returnValue = null;
        switch (valueType) {
            case INTEGER: 
            case BOOLEAN: 
            case LOGICAL: {
                IntByReference iVal = new IntByReference(((Integer)value).intValue());
                returnValue = this.engine.sdaiCreateADB(valueType.ordinal(), iVal);
                break;
            }
            case REAL: {
                DoubleByReference dVal = new DoubleByReference(((Double)value).doubleValue());
                returnValue = this.engine.sdaiCreateADB(valueType.ordinal(), dVal);
                break;
            }
            case STRING: {
                returnValue = this.engine.sdaiCreateADB(valueType.ordinal(), (String)value);
                break;
            }
            default: {
                returnValue = this.engine.sdaiCreateADB(valueType.ordinal(), (Pointer)value);
            }
        }
        return returnValue;
    }

    public Pointer sdaiCreateAggr(Pointer instance, int attribute) {
        return this.engine.sdaiCreateAggr(instance, attribute);
    }

    public Pointer sdaiCreateAggrBN(Pointer instance, String attributeName) {
        return this.engine.sdaiCreateAggrBN(instance, attributeName);
    }

    public Pointer sdaiCreateInstance(Pointer model, int entity) {
        return this.engine.sdaiCreateInstance(model, entity);
    }

    public Pointer sdaiCreateInstanceBN(Pointer model, String entityName) {
        return this.engine.sdaiCreateInstanceBN(model, entityName);
    }

    public Pointer sdaiCreateInstanceBNEI(Pointer model, String entityName, int express_id) {
        return this.engine.sdaiCreateInstanceBNEI(model, entityName, express_id);
    }

    public Pointer sdaiCreateIterator(Pointer aggregate) {
        return this.engine.sdaiCreateIterator(aggregate);
    }

    public void sdaiDeleteInstance(Pointer instance) {
        this.engine.sdaiDeleteInstance(instance);
    }

    public void sdaiDeleteIterator(Pointer iterator) {
        this.engine.sdaiDeleteIterator(iterator);
    }

    public void sdaiEnd(Pointer iterator) {
        this.engine.sdaiEnd(iterator);
    }

    public int sdaiErrorQuery() {
        return this.engine.sdaiErrorQuery();
    }

    public Object sdaiGetAggrByIterator(Pointer iterator, SdaiTypes valueType) {
        Object returnValue = null;
        switch (valueType) {
            case REAL: {
                DoubleByReference dVal = new DoubleByReference();
                this.engine.sdaiGetAggrByIterator(iterator, valueType.ordinal(), dVal);
                returnValue = new Double(dVal.getValue());
                break;
            }
            case INTEGER: 
            case BOOLEAN: 
            case LOGICAL: {
                IntByReference iVal = new IntByReference();
                this.engine.sdaiGetAggrByIterator(iterator, valueType.ordinal(), iVal);
                returnValue = new Integer(iVal.getValue());
                break;
            }
            case STRING: {
                PointerByReference sVal = new PointerByReference();
                this.engine.sdaiGetAggrByIterator(iterator, valueType.ordinal(), sVal);
                returnValue = sVal.getValue().getString(0L);
                break;
            }
            default: {
                PointerByReference ptr = new PointerByReference();
                this.engine.sdaiGetAggrByIterator(iterator, valueType.ordinal(), ptr);
                returnValue = ptr.getValue();
            }
        }
        return returnValue;
    }

    public Object sdaiGetAttr(Pointer instance, int attribute, SdaiTypes valueType) {
        Object returnValue = null;
        switch (valueType) {
            case REAL: {
                DoubleByReference dVal = new DoubleByReference();
                this.engine.sdaiGetAggrByIterator(instance, valueType.ordinal(), dVal);
                returnValue = new Double(dVal.getValue());
                break;
            }
            case INTEGER: 
            case BOOLEAN: 
            case LOGICAL: {
                IntByReference iVal = new IntByReference();
                this.engine.sdaiGetAggrByIterator(instance, valueType.ordinal(), iVal);
                returnValue = new Integer(iVal.getValue());
                break;
            }
            case STRING: {
                PointerByReference sVal = new PointerByReference();
                this.engine.sdaiGetAggrByIterator(instance, valueType.ordinal(), sVal);
                returnValue = sVal.getValue().getString(0L);
                break;
            }
            default: {
                PointerByReference ptr = new PointerByReference();
                this.engine.sdaiGetAggrByIterator(instance, valueType.ordinal(), ptr);
                returnValue = ptr.getValue();
            }
        }
        return returnValue;
    }

    public Pointer sdaiGetAttrDefinition(Pointer entity, String attributeName) {
        return this.engine.sdaiGetAttrDefinition(entity, attributeName);
    }

    public SurfaceProperties initializeModelling(Pointer model, double scale) {
        IntByReference pV = new IntByReference();
        IntByReference pI = new IntByReference();
        this.engine.initializeModelling(model, pV, pI, scale);
        int noVertices = pV.getValue();
        int noIndices = pI.getValue();
        return new SurfaceProperties(model, noVertices, noIndices, scale);
    }

    public void setPostProcessing(Pointer model, int on) {
        this.engine.setPostProcessing(model, on);
    }

    public int initializeClashes(Pointer model, double dist) {
        IntByReference pV = new IntByReference();
        this.engine.initializeClashes(model, pV, dist);
        int noClashes = pV.getValue();
        return noClashes;
    }

    public int internalGetP21Line(Pointer instanceId) {
        return this.engine.internalGetP21Line(instanceId);
    }

    public Pointer internalGetInstanceFromP21Line(Pointer modelId, int expressId) {
        return this.engine.internalGetInstanceFromP21Line(modelId, expressId);
    }

    public Pointer xxxxGetEntityAndSubTypesExtentBN(Pointer model, String entityName) {
        return this.engine.xxxxGetEntityAndSubTypesExtentBN(model, entityName);
    }

    public long owlGetModel(Pointer model) {
        LongByReference owlInstanceReference = new LongByReference();
        this.engine.owlGetModel(model, owlInstanceReference);
        return owlInstanceReference.getValue();
    }

    public long owlGetInstance(Pointer model, Pointer instance) {
        LongByReference owlInstanceReference = new LongByReference();
        this.engine.owlGetInstance(model, instance, owlInstanceReference);
        return owlInstanceReference.getValue();
    }

    public float[] owlGetMappedItem(Pointer model, Pointer instance, long owlInstance) {
        Memory memory = new Memory((long)(64 * this.getPlatformMultiplier()));
        LongByReference owlInstanceReference = new LongByReference();
        owlInstanceReference.setValue(owlInstance);
        this.engine.owlGetMappedItem(model, instance, owlInstanceReference, (Pointer)memory);
        if (this.getPlatformMultiplier() == 2) {
            double[] doubleArray = memory.getDoubleArray(0L, 16);
            float[] floatArray = new float[16];
            for (int i = 0; i < 16; ++i) {
                floatArray[i] = (float)doubleArray[i];
            }
            return floatArray;
        }
        return memory.getFloatArray(0L, 16);
    }

    public double getArea(Pointer model, Pointer instance) {
        return this.engine.GetArea(instance, Pointer.NULL, Pointer.NULL);
    }

    public double getVolume(Pointer model, Pointer instance) {
        return this.engine.GetVolume(instance, Pointer.NULL, Pointer.NULL);
    }

    public class InstanceTransformationMatrix {
        Pointer model;
        Pointer instance;
        double _11;
        double _12;
        double _13;
        double _14;
        double _21;
        double _22;
        double _23;
        double _24;
        double _31;
        double _32;
        double _33;
        double _34;
        double _41;
        double _42;
        double _43;
        double _44;

        public InstanceTransformationMatrix(Pointer model, Pointer instance, double _11, double _12, double _13, double _14, double _21, double _22, double _23, double _24, double _31, double _32, double _33, double _34, double _41, double _42, double _43, double _44) {
            this.model = model;
            this.instance = instance;
            this._11 = _11;
            this._12 = _12;
            this._13 = _13;
            this._14 = _14;
            this._21 = _21;
            this._22 = _22;
            this._23 = _23;
            this._24 = _24;
            this._31 = _31;
            this._32 = _32;
            this._33 = _33;
            this._34 = _34;
            this._41 = _41;
            this._42 = _42;
            this._43 = _43;
            this._44 = _44;
        }

        public Pointer getModel() {
            return this.model;
        }

        public Pointer getInstance() {
            return this.instance;
        }

        public double get_11() {
            return this._11;
        }

        public double get_12() {
            return this._12;
        }

        public double get_13() {
            return this._13;
        }

        public double get_14() {
            return this._14;
        }

        public double get_21() {
            return this._21;
        }

        public double get_22() {
            return this._22;
        }

        public double get_23() {
            return this._23;
        }

        public double get_24() {
            return this._24;
        }

        public double get_31() {
            return this._31;
        }

        public double get_32() {
            return this._32;
        }

        public double get_33() {
            return this._33;
        }

        public double get_34() {
            return this._34;
        }

        public double get_41() {
            return this._41;
        }

        public double get_42() {
            return this._42;
        }

        public double get_43() {
            return this._43;
        }

        public double get_44() {
            return this._44;
        }
    }

    public class InstanceDerivedTransformationMatrix {
        Pointer model;
        Pointer instance;
        double _11;
        double _12;
        double _13;
        double _14;
        double _21;
        double _22;
        double _23;
        double _24;
        double _31;
        double _32;
        double _33;
        double _34;
        double _41;
        double _42;
        double _43;
        double _44;

        public InstanceDerivedTransformationMatrix(Pointer model, Pointer instance, double _11, double _12, double _13, double _14, double _21, double _22, double _23, double _24, double _31, double _32, double _33, double _34, double _41, double _42, double _43, double _44) {
            this.model = model;
            this.instance = instance;
            this._11 = _11;
            this._12 = _12;
            this._13 = _13;
            this._14 = _14;
            this._21 = _21;
            this._22 = _22;
            this._23 = _23;
            this._24 = _24;
            this._31 = _31;
            this._32 = _32;
            this._33 = _33;
            this._34 = _34;
            this._41 = _41;
            this._42 = _42;
            this._43 = _43;
            this._44 = _44;
        }

        public Pointer getModel() {
            return this.model;
        }

        public Pointer getInstance() {
            return this.instance;
        }

        public double get_11() {
            return this._11;
        }

        public double get_12() {
            return this._12;
        }

        public double get_13() {
            return this._13;
        }

        public double get_14() {
            return this._14;
        }

        public double get_21() {
            return this._21;
        }

        public double get_22() {
            return this._22;
        }

        public double get_23() {
            return this._23;
        }

        public double get_24() {
            return this._24;
        }

        public double get_31() {
            return this._31;
        }

        public double get_32() {
            return this._32;
        }

        public double get_33() {
            return this._33;
        }

        public double get_34() {
            return this._34;
        }

        public double get_41() {
            return this._41;
        }

        public double get_42() {
            return this._42;
        }

        public double get_43() {
            return this._43;
        }

        public double get_44() {
            return this._44;
        }
    }

    public class InstanceDerivedBoundingBox {
        Pointer model;
        Pointer instance;
        double ox;
        double oy;
        double oz;
        double vx;
        double vy;
        double vz;

        public InstanceDerivedBoundingBox(Pointer model, Pointer instance, double ox, double oy, double oz, double vx, double vy, double vz) {
            this.model = model;
            this.instance = instance;
            this.ox = ox;
            this.oy = oy;
            this.oz = oz;
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
        }

        public Pointer getModel() {
            return this.model;
        }

        public Pointer getInstance() {
            return this.instance;
        }

        public double getOx() {
            return this.ox;
        }

        public double getOy() {
            return this.oy;
        }

        public double getOz() {
            return this.oz;
        }

        public double getVx() {
            return this.vx;
        }

        public double getVy() {
            return this.vy;
        }

        public double getVz() {
            return this.vz;
        }
    }

    public class InstanceDerivedProperties {
        private int model;
        private Pointer instance;
        private double height;
        private double width;
        private double thickness;

        public InstanceDerivedProperties(int model, Pointer instance, double height, double width, double thickness) {
            this.model = model;
            this.instance = instance;
            this.height = height;
            this.width = width;
            this.thickness = thickness;
        }

        public int getModel() {
            return this.model;
        }

        public Pointer getInstance() {
            return this.instance;
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getThickness() {
            return this.thickness;
        }
    }

    public static class SurfaceProperties {
        private Pointer model;
        private Pointer instance;
        private Pointer instanceList;
        private int noVertices;
        private int noIndices;
        private double scale;

        public SurfaceProperties(Pointer model, int noVertices, int noIndices, double scale) {
            this.model = model;
            this.noVertices = noVertices;
            this.noIndices = noIndices;
            this.scale = scale;
            this.instance = null;
            this.instanceList = null;
        }

        public SurfaceProperties(Pointer model, Pointer instance, int noVertices, int noIndices, double scale) {
            this(model, noVertices, noIndices, scale);
            this.instance = instance;
        }

        public SurfaceProperties(Pointer model, Pointer instance, Pointer instanceList, int noVertices, int noIndices, double scale) {
            this(model, instance, noVertices, noIndices, scale);
            this.instanceList = instanceList;
        }

        public Pointer getModel() {
            return this.model;
        }

        public Pointer getInstance() {
            return this.instance;
        }

        public Pointer getInstanceList() {
            return this.instanceList;
        }

        public int getIndicesCount() {
            return this.noIndices;
        }

        public int getVerticesCount() {
            return this.noVertices;
        }

        public double getScale() {
            return this.scale;
        }

        public boolean hasInstance() {
            return this.instance != null;
        }

        public boolean hasInstanceList() {
            return this.instanceList != null;
        }
    }
}

