/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bimserver.ifcengine.Command;
import org.bimserver.ifcengine.JvmIfcEngine;
import org.bimserver.ifcengine.JvmIfcEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineClash;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineFilter;
import org.bimserver.plugins.renderengine.RenderEngineGeometry;
import org.bimserver.plugins.renderengine.RenderEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineModel;
import org.bimserver.plugins.renderengine.RenderEngineSettings;
import org.bimserver.plugins.renderengine.RenderEngineSurfaceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmIfcEngineModel
implements RenderEngineModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmIfcEngineModel.class);
    private final int modelId;
    private final JvmIfcEngine failSafeIfcEngine;
    public int[] indices;
    public float[] vertices;
    public float[] normals;

    public JvmIfcEngineModel(JvmIfcEngine failSafeIfcEngine, int modelId) {
        this.failSafeIfcEngine = failSafeIfcEngine;
        this.modelId = modelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderEngineSurfaceProperties initializeModelling() throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.INITIALIZE_MODELLING);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.flush();
            int noIndices = this.failSafeIfcEngine.readInt();
            int noVertices = this.failSafeIfcEngine.readInt();
            return new RenderEngineSurfaceProperties(this.modelId, noVertices, noIndices, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostProcessing(boolean postProcessing) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.SET_POSTPROCESSING);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeBoolean(postProcessing);
            this.failSafeIfcEngine.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(int format, int mask) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.SET_FORMAT);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(format);
            this.failSafeIfcEngine.writeInt(mask);
            this.failSafeIfcEngine.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(int format, int mask) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.SET_FILTER);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(format);
            this.failSafeIfcEngine.writeInt(mask);
            this.failSafeIfcEngine.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderEngineGeometry finalizeModelling(RenderEngineSurfaceProperties surfaceProperties) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            int i;
            if (surfaceProperties.getIndicesCount() == 0 || surfaceProperties.getVerticesCount() == 0) {
                return null;
            }
            LOGGER.info(surfaceProperties.getIndicesCount() + " indices, " + surfaceProperties.getVerticesCount() + " vertices");
            if (surfaceProperties.getIndicesCount() < 0) {
                throw new RenderEngineException("Number of indices negative " + surfaceProperties.getIndicesCount());
            }
            if (surfaceProperties.getVerticesCount() < 0) {
                throw new RenderEngineException("Number of vertices negative " + surfaceProperties.getVerticesCount());
            }
            this.failSafeIfcEngine.writeCommand(Command.FINALIZE_MODELLING);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(surfaceProperties.getIndicesCount());
            this.failSafeIfcEngine.writeInt(surfaceProperties.getVerticesCount());
            this.failSafeIfcEngine.flush();
            this.indices = new int[surfaceProperties.getIndicesCount()];
            this.vertices = new float[surfaceProperties.getVerticesCount() * 3];
            this.normals = new float[surfaceProperties.getVerticesCount() * 3];
            for (i = 0; i < this.indices.length; ++i) {
                this.indices[i] = this.failSafeIfcEngine.readInt();
            }
            for (i = 0; i < this.vertices.length; ++i) {
                this.vertices[i] = this.failSafeIfcEngine.readFloat();
            }
            for (i = 0; i < this.normals.length; ++i) {
                this.normals[i] = this.failSafeIfcEngine.readFloat();
            }
            return new RenderEngineGeometry(this.indices, this.vertices, this.normals, new float[0], new int[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends RenderEngineInstance> getInstances(String name) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.GET_INSTANCES);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeUTF(name);
            this.failSafeIfcEngine.flush();
            int nrInstances = this.failSafeIfcEngine.readInt();
            ArrayList<JvmIfcEngineInstance> instances = new ArrayList<JvmIfcEngineInstance>();
            for (int i = 0; i < nrInstances; ++i) {
                instances.add(new JvmIfcEngineInstance(this.failSafeIfcEngine, this.modelId, this.failSafeIfcEngine.readInt()));
            }
            return instances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.CLOSE_MODEL);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RenderEngineClash> findClashesWithEids(double d) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.FIND_CLASHES_BY_EID);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeDouble(d);
            this.failSafeIfcEngine.flush();
            int nrClashes = this.failSafeIfcEngine.readInt();
            HashSet<RenderEngineClash> clashes = new HashSet<RenderEngineClash>();
            for (int i = 0; i < nrClashes; ++i) {
                RenderEngineClash clash = new RenderEngineClash();
                clashes.add(clash);
                clash.setEid1(this.failSafeIfcEngine.readLong());
                clash.setEid2(this.failSafeIfcEngine.readLong());
            }
            return clashes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RenderEngineClash> findClashesWithGuids(double d) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.FIND_CLASHES_BY_GUID);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeDouble(d);
            this.failSafeIfcEngine.flush();
            int nrClashes = this.failSafeIfcEngine.readInt();
            HashSet<RenderEngineClash> clashes = new HashSet<RenderEngineClash>();
            for (int i = 0; i < nrClashes; ++i) {
                RenderEngineClash clash = new RenderEngineClash();
                clashes.add(clash);
                clash.setGuid1(this.failSafeIfcEngine.readString());
                clash.setGuid2(this.failSafeIfcEngine.readString());
            }
            return clashes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderEngineInstance getInstanceFromExpressId(int oid) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.GET_INSTANCE_FROM_EXPRESSID);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(oid);
            this.failSafeIfcEngine.flush();
            int instanceId = this.failSafeIfcEngine.readInt();
            if (instanceId == -1) {
                throw new RenderEngineException("Instance with express id " + oid + " not found");
            }
            return new JvmIfcEngineInstance(this.failSafeIfcEngine, this.modelId, instanceId);
        }
    }

    public void setSettings(RenderEngineSettings settings) throws RenderEngineException {
        int setting = 0;
        int mask = 0;
        mask += 4;
        setting += settings.getPrecision().getValue();
        mask += 8;
        setting += settings.getIndexFormat().getValue();
        mask += 32;
        setting += settings.isGenerateNormals() ? 32 : 0;
        mask += 256;
        setting += settings.isGenerateTriangles() ? 256 : 0;
        this.setFormat(setting += settings.isGenerateWireFrame() ? 4096 : 0, mask += 4096);
    }

    public void generateGeneralGeometry() throws RenderEngineException {
    }

    public void setFilter(RenderEngineFilter renderEngineFilter) throws RenderEngineException {
        int setting = 0;
        int mask = 0;
        this.setFilter(setting, mask += 128);
        setting += renderEngineFilter.isTranformGeometry() ? 128 : 0;
    }
}

