/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bimserver.ifcengine.Command;
import org.bimserver.ifcengine.JvmIfcEngineModel;
import org.bimserver.ifcengine.jvm.IfcEngineServer;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmIfcEngine
implements RenderEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmIfcEngine.class);
    private Process process;
    private DataInputStream in;
    private DataOutputStream out;
    private InputStream err;
    private final Path schemaFile;
    private final Path nativeBaseDir;
    private boolean useSecondJvm = true;
    private final Path tempDir;
    private volatile RenderEngineException lastException;
    private final List<String> classPathEntries;
    private String classLocation;

    public JvmIfcEngine(Path schemaFile, Path nativeBaseDir, Path tempDir, String classLocation, List<String> classPathEntries) throws RenderEngineException {
        this.schemaFile = schemaFile;
        this.nativeBaseDir = nativeBaseDir;
        this.tempDir = tempDir;
        this.classLocation = classLocation;
        this.classPathEntries = classPathEntries;
    }

    public void init() throws RenderEngineException {
        if (this.useSecondJvm) {
            this.startJvm();
        } else {
            this.startLocal();
        }
    }

    private void startLocal() {
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            IfcEngineServer ifcEngineServer = new IfcEngineServer(this.schemaFile.toString(), pipedInputStream, pipedOutputStream, null);
            this.in = new DataInputStream(new BufferedInputStream(pipedInputStream));
            this.out = new DataOutputStream(new BufferedOutputStream(pipedOutputStream));
            ifcEngineServer.start();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void startJvm() throws RenderEngineException {
        try {
            if (!Files.exists(this.tempDir, new LinkOption[0])) {
                Files.createDirectory(this.tempDir, new FileAttribute[0]);
            }
            StringBuilder command = new StringBuilder("java");
            if (this.nativeBaseDir.toString().contains(" ")) {
                command.append(" -Djna.library.path=\"" + this.nativeBaseDir.toString() + "\"");
            } else {
                command.append(" -Djna.library.path=" + this.nativeBaseDir.toString());
            }
            if (this.tempDir.toString().contains(" ")) {
                command.append(" -Djava.io.tmpdir=\"" + this.tempDir.toString() + "\"");
            } else {
                command.append(" -Djava.io.tmpdir=" + this.tempDir.toString());
            }
            command.append(" -classpath ");
            command.append("\"");
            command.append(this.classLocation + File.pathSeparator);
            if (this.classPathEntries != null) {
                for (String classPathEntry : this.classPathEntries) {
                    command.append(classPathEntry + File.pathSeparator);
                }
            }
            command.append("\"");
            String mem = "512m";
            if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
                int megs = (int)(Runtime.getRuntime().maxMemory() / 2000000L);
                if (megs > 1024) {
                    megs = 1024;
                }
                mem = String.valueOf(megs + "m");
            }
            command.append(" -Xmx" + mem);
            command.append(" -Xms" + mem);
            command.append(" org.bimserver.ifcengine.jvm.IfcEngineServer");
            if (this.schemaFile.toString().contains(" ")) {
                command.append(" \"" + this.schemaFile.toString() + "\"");
            } else {
                command.append(" " + this.schemaFile.toString());
            }
            this.process = Runtime.getRuntime().exec(command.toString());
            this.in = new DataInputStream(new BufferedInputStream(this.process.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.process.getOutputStream()));
            this.err = this.process.getErrorStream();
            this.startErrorHandler();
            Thread thread = new Thread("JvmIfcEngine"){

                @Override
                public void run() {
                    try {
                        int result = JvmIfcEngine.this.process.waitFor();
                        if (result != 0) {
                            JvmIfcEngine.this.lastException = new RenderEngineException("Process ended with errorcode: " + result);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        }
        catch (Exception e) {
            throw new RenderEngineException(e);
        }
    }

    private void startErrorHandler() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[1024];
                try {
                    int red = JvmIfcEngine.this.err.read(buffer);
                    while (red != -1) {
                        LOGGER.error(new String(buffer, 0, red));
                        red = JvmIfcEngine.this.err.read(buffer);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        };
        Thread thread = new Thread(runnable, "FailSafeIfcEngine ErrorHandler");
        thread.start();
    }

    public synchronized JvmIfcEngineModel openModel(File ifcFile) throws RenderEngineException {
        this.checkRunning();
        this.writeCommand(Command.OPEN_MODEL);
        this.writeUTF(ifcFile.getAbsolutePath());
        this.flush();
        int modelId = this.readInt();
        return new JvmIfcEngineModel(this, modelId);
    }

    public synchronized JvmIfcEngineModel openModel(InputStream inputStream, int size) throws RenderEngineException {
        this.checkRunning();
        this.writeCommand(Command.OPEN_MODEL_STREAMING);
        try {
            this.out.writeInt(size);
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.out);
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
        this.flush();
        int modelId = this.readInt();
        return new JvmIfcEngineModel(this, modelId);
    }

    public synchronized JvmIfcEngineModel openModel(InputStream inputStream) throws RenderEngineException {
        this.checkRunning();
        this.writeCommand(Command.OPEN_MODEL_STREAMING_PARTS);
        try {
            byte[] buffer = new byte[4096];
            int read = inputStream.read(buffer, 0, 4096);
            while (read != -1) {
                this.out.writeInt(read);
                this.out.write(buffer, 0, read);
                read = inputStream.read(buffer, 0, 4096);
            }
            this.out.writeInt(-1);
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
        this.flush();
        int modelId = this.readInt();
        return new JvmIfcEngineModel(this, modelId);
    }

    private void checkRunning() throws RenderEngineException {
        if (this.lastException != null) {
            throw this.lastException;
        }
    }

    public int readInt() throws RenderEngineException {
        this.checkRunning();
        try {
            return this.in.readInt();
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public void flush() throws RenderEngineException {
        this.checkRunning();
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void writeUTF(String value) throws RenderEngineException {
        this.checkRunning();
        try {
            this.out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public void writeCommand(Command command) throws RenderEngineException {
        this.checkRunning();
        try {
            this.out.writeByte(command.getId());
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error", e);
        }
    }

    public synchronized void close() throws RenderEngineException {
        this.checkRunning();
        if (this.process != null) {
            try {
                this.writeCommand(Command.CLOSE);
                this.flush();
            }
            catch (RenderEngineException e) {
                LOGGER.error("", (Throwable)e);
            }
            this.process.destroy();
        }
    }

    public void writeInt(int value) throws RenderEngineException {
        this.checkRunning();
        try {
            this.out.writeInt(value);
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public void writeBoolean(boolean value) throws RenderEngineException {
        this.checkRunning();
        try {
            this.out.writeBoolean(value);
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public float readFloat() throws RenderEngineException {
        this.checkRunning();
        try {
            return this.in.readFloat();
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public String readString() throws RenderEngineException {
        this.checkRunning();
        try {
            return this.in.readUTF();
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public void writeDouble(double d) throws RenderEngineException {
        this.checkRunning();
        try {
            this.out.writeDouble(d);
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public long readLong() throws RenderEngineException {
        this.checkRunning();
        try {
            return this.in.readLong();
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public JvmIfcEngineModel openModel(byte[] bytes) throws RenderEngineException {
        this.checkRunning();
        return this.openModel(new ByteArrayInputStream(bytes), bytes.length);
    }

    public void writeLong(long value) throws RenderEngineException {
        this.checkRunning();
        try {
            this.out.writeLong(value);
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }

    public double readDouble() throws RenderEngineException {
        this.checkRunning();
        try {
            return this.in.readDouble();
        }
        catch (IOException e) {
            throw new RenderEngineException("Unknown IFC Engine error");
        }
    }
}

