package org.bimserver.plugins.serializers;

/******************************************************************************
 * Copyright (C) 2009-2016  BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see {@literal<http://www.gnu.org/licenses/>}.
 *****************************************************************************/

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.plugins.PluginManagerInterface;

public interface Serializer {
	void init(IfcModelInterface model, ProjectInfo projectInfo, PluginManagerInterface pluginManager, PackageMetaData packageMetaData, boolean normalizeOids) throws SerializerException;
	void writeToFile(Path file, ProgressReporter progressReporter) throws SerializerException;
	byte[] getBytes();
	IfcModelInterface getModel();
	InputStream getInputStream() throws IOException;
	void writeToOutputStream(OutputStream outputStream, ProgressReporter progressReporter) throws SerializerException;

	/*
	 * The serializer must implement this method, but in most cases won't have
	 * to do anything. Only when reusing a serializer, this method can be used
	 * to cleanup/setup
	 */
	void reset();
	boolean allowCaching();
}