/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.rankeval.EvalQueryQuality;
import org.opensearch.index.rankeval.EvaluationMetric;
import org.opensearch.index.rankeval.RankEvalRequest;
import org.opensearch.index.rankeval.RankEvalResponse;
import org.opensearch.index.rankeval.RankEvalSpec;
import org.opensearch.index.rankeval.RatedRequest;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportRankEvalAction
extends HandledTransportAction<RankEvalRequest, RankEvalResponse> {
    private final Client client;
    private final ScriptService scriptService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportRankEvalAction(ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, NamedXContentRegistry namedXContentRegistry) {
        super("indices:data/read/rank_eval", transportService, actionFilters, RankEvalRequest::new);
        this.scriptService = scriptService;
        this.namedXContentRegistry = namedXContentRegistry;
        this.client = client;
    }

    protected void doExecute(Task task, RankEvalRequest request, ActionListener<RankEvalResponse> listener) {
        RankEvalSpec evaluationSpecification = request.getRankEvalSpec();
        EvaluationMetric metric = evaluationSpecification.getMetric();
        List<RatedRequest> ratedRequests = evaluationSpecification.getRatedRequests();
        ConcurrentHashMap<String, Exception> errors = new ConcurrentHashMap<String, Exception>(ratedRequests.size());
        HashMap<String, TemplateScript.Factory> scriptsWithoutParams = new HashMap<String, TemplateScript.Factory>();
        for (Map.Entry<String, Script> entry : evaluationSpecification.getTemplates().entrySet()) {
            scriptsWithoutParams.put(entry.getKey(), (TemplateScript.Factory)this.scriptService.compile(entry.getValue(), TemplateScript.CONTEXT));
        }
        MultiSearchRequest msearchRequest = new MultiSearchRequest();
        msearchRequest.maxConcurrentSearchRequests(evaluationSpecification.getMaxConcurrentSearches());
        ArrayList<RatedRequest> ratedRequestsInSearch = new ArrayList<RatedRequest>();
        for (RatedRequest ratedRequest : ratedRequests) {
            SearchSourceBuilder evaluationRequest = ratedRequest.getEvaluationRequest();
            if (evaluationRequest == null) {
                Map<String, Object> params = ratedRequest.getParams();
                String templateId = ratedRequest.getTemplateId();
                TemplateScript.Factory templateScript = (TemplateScript.Factory)scriptsWithoutParams.get(templateId);
                String resolvedRequest = templateScript.newInstance(params).execute();
                try (XContentParser subParser = XContentHelper.createParser((NamedXContentRegistry)this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)new BytesArray(resolvedRequest), (MediaType)XContentType.JSON);){
                    evaluationRequest = SearchSourceBuilder.fromXContent((XContentParser)subParser, (boolean)false);
                    RatedRequest.validateEvaluatedQuery(evaluationRequest);
                }
                catch (IOException e) {
                    errors.put(ratedRequest.getId(), e);
                    continue;
                }
            }
            if (metric.forcedSearchSize().isPresent()) {
                evaluationRequest.size(metric.forcedSearchSize().getAsInt());
            }
            ratedRequestsInSearch.add(ratedRequest);
            List<String> summaryFields = ratedRequest.getSummaryFields();
            if (summaryFields.isEmpty()) {
                evaluationRequest.fetchSource(false);
            } else {
                evaluationRequest.fetchSource(summaryFields.toArray(new String[summaryFields.size()]), new String[0]);
            }
            SearchRequest searchRequest = new SearchRequest(request.indices(), evaluationRequest);
            searchRequest.indicesOptions(request.indicesOptions());
            searchRequest.searchType(request.searchType());
            msearchRequest.add(searchRequest);
        }
        assert (ratedRequestsInSearch.size() == msearchRequest.requests().size());
        this.client.multiSearch(msearchRequest, (ActionListener)new RankEvalActionListener(listener, metric, ratedRequestsInSearch.toArray(new RatedRequest[ratedRequestsInSearch.size()]), errors));
    }

    class RankEvalActionListener
    implements ActionListener<MultiSearchResponse> {
        private final ActionListener<RankEvalResponse> listener;
        private final RatedRequest[] specifications;
        private final Map<String, Exception> errors;
        private final EvaluationMetric metric;

        RankEvalActionListener(ActionListener<RankEvalResponse> listener, EvaluationMetric metric, RatedRequest[] specifications, Map<String, Exception> errors) {
            this.listener = listener;
            this.metric = metric;
            this.errors = errors;
            this.specifications = specifications;
        }

        public void onResponse(MultiSearchResponse multiSearchResponse) {
            int responsePosition = 0;
            HashMap<String, EvalQueryQuality> responseDetails = new HashMap<String, EvalQueryQuality>(this.specifications.length);
            for (MultiSearchResponse.Item response : multiSearchResponse.getResponses()) {
                RatedRequest specification = this.specifications[responsePosition];
                if (!response.isFailure()) {
                    SearchHit[] hits = response.getResponse().getHits().getHits();
                    EvalQueryQuality queryQuality = this.metric.evaluate(specification.getId(), hits, specification.getRatedDocs());
                    responseDetails.put(specification.getId(), queryQuality);
                } else {
                    this.errors.put(specification.getId(), response.getFailure());
                }
                ++responsePosition;
            }
            this.listener.onResponse((Object)new RankEvalResponse(this.metric.combine(responseDetails.values()), responseDetails, this.errors));
        }

        public void onFailure(Exception exception) {
            this.listener.onFailure(exception);
        }
    }
}

