/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import org.opensearch.dataprepper.plugins.source.s3.parser.ParsedMessage;
import org.opensearch.dataprepper.plugins.source.s3.parser.S3EventBridgeNotificationParser;
import org.opensearch.dataprepper.plugins.source.s3.parser.S3EventNotificationParser;
import org.opensearch.dataprepper.plugins.source.s3.parser.S3NotificationParser;
import software.amazon.awssdk.services.sqs.model.Message;

public class SqsMessageParser {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final S3SourceConfig s3SourceConfig;
    private final S3NotificationParser s3NotificationParser;

    public SqsMessageParser(S3SourceConfig s3SourceConfig) {
        this.s3SourceConfig = s3SourceConfig;
        this.s3NotificationParser = SqsMessageParser.createNotificationParser(s3SourceConfig);
    }

    public Collection<ParsedMessage> parseSqsMessages(Collection<Message> sqsMessages) {
        return sqsMessages.stream().map(this::convertS3EventMessages).collect(Collectors.toList());
    }

    private ParsedMessage convertS3EventMessages(Message message) {
        return this.s3NotificationParser.parseMessage(message, OBJECT_MAPPER);
    }

    private static S3NotificationParser createNotificationParser(S3SourceConfig s3SourceConfig) {
        switch (s3SourceConfig.getNotificationSource()) {
            case EVENTBRIDGE: {
                return new S3EventBridgeNotificationParser();
            }
        }
        return new S3EventNotificationParser();
    }
}

