/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.handler;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.model.TableMetadata;

public class StringTypeHandler
implements MySQLDataTypeHandler {
    @Override
    public String handle(MySQLDataType columnType, String columnName, Object value, TableMetadata metadata) {
        if (columnType.isStringBytes() && value instanceof byte[]) {
            return new String((byte[])value);
        }
        if (columnType.isStringEnum() && value instanceof Integer) {
            return this.getEnumValue((Integer)value, metadata.getEnumStrValues().get(columnName));
        }
        if (columnType.isStringSet() && value instanceof Long) {
            return this.getSetValues((Long)value, metadata.getSetStrValues().get(columnName)).toString();
        }
        return value.toString();
    }

    private List<String> getSetValues(long numericValue, String[] setStrValues) {
        ArrayList<String> setValues = new ArrayList<String>();
        for (int i = 0; i < setStrValues.length; ++i) {
            if ((numericValue & 1L << i) == 0L) continue;
            setValues.add(setStrValues[i].trim());
        }
        return setValues;
    }

    private String getEnumValue(int numericValue, String[] enumStrValues) {
        return enumStrValues[numericValue - 1];
    }
}

