/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.handler;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.model.TableMetadata;

public class NumericTypeHandler
implements MySQLDataTypeHandler {
    @Override
    public Number handle(MySQLDataType columnType, String columnName, Object value, TableMetadata metadata) {
        if (value == null) {
            return null;
        }
        if (!columnType.isNumeric() && !columnType.isBit()) {
            throw new IllegalArgumentException("ColumnType is not numeric: " + String.valueOf((Object)columnType));
        }
        return this.handleNumericType(columnType, value);
    }

    private Number handleNumericType(MySQLDataType columnType, Object value) {
        if (columnType.isNumericUnsigned()) {
            if (columnType.isBigIntUnsigned()) {
                return this.handleUnsignedBigInt(value);
            }
            return this.handleUnsignedNumber(value, columnType.getUnsignedMask());
        }
        if (columnType.isBit()) {
            return this.handleBit(value);
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new IllegalArgumentException("Unsupported value type. The value is of type: " + String.valueOf(value.getClass()));
    }

    private Number handleBit(Object value) {
        if (value instanceof BitSet) {
            return NumericTypeHandler.bitSetToBigInteger((BitSet)value);
        }
        if (value instanceof Map) {
            Object data = ((Map)value).get("bytes");
            if (data instanceof byte[]) {
                return new BigInteger(1, (byte[])data);
            }
            byte[] bytes = ((String)data).getBytes();
            return new BigInteger(1, bytes);
        }
        throw new IllegalArgumentException("Unsupported value type. The value is of type: " + String.valueOf(value.getClass()));
    }

    private Number handleUnsignedNumber(Object value, long mask) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Unsupported value type. The value is of type: " + String.valueOf(value.getClass()));
        }
        long longVal = ((Number)value).longValue();
        return longVal < 0L ? longVal & mask : longVal;
    }

    private Number handleUnsignedBigInt(Object value) {
        if (value instanceof Number) {
            long longVal = ((Number)value).longValue();
            if (longVal < 0L) {
                return BigInteger.valueOf(longVal & Long.MAX_VALUE).add(BigInteger.valueOf(Long.MAX_VALUE)).add(BigInteger.ONE);
            }
            return (Number)value;
        }
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            byte[] bytes = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                bytes[i] = ((Number)list.get(i)).byteValue();
            }
            return new BigInteger(1, bytes);
        }
        throw new IllegalArgumentException("Unsupported value type. The value is of type: " + value.getClass().getName());
    }

    private static BigInteger bitSetToBigInteger(BitSet bitSet) {
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            result = result.setBit(i);
        }
        return result;
    }
}

