/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearchapi.model;

import java.util.HashMap;
import java.util.Map;

public class BulkActionAndMetadataObject {
    private String action;
    private Map<String, Object> requestModel;
    private static final String emptyStringLiteral = "";

    public BulkActionAndMetadataObject(Map<String, Object> requestModel) {
        this.requestModel = requestModel;
        this.action = this.isRequestModelValid() ? requestModel.keySet().stream().findFirst().orElse(emptyStringLiteral) : emptyStringLiteral;
    }

    public String getDocId() {
        return this.getKeyInNestedMap("_id");
    }

    public String getIndex() {
        return this.getKeyInNestedMap("_index");
    }

    private String getKeyInNestedMap(String key) {
        if (!this.isRequestModelValid()) {
            return emptyStringLiteral;
        }
        HashMap apiAttributesMap = this.requestModel.getOrDefault(this.action, new HashMap());
        if (!(apiAttributesMap instanceof Map)) {
            return emptyStringLiteral;
        }
        return ((Map)apiAttributesMap).getOrDefault(key, emptyStringLiteral);
    }

    private boolean isRequestModelValid() {
        return this.requestModel != null && !this.requestModel.isEmpty();
    }

    public String getAction() {
        return this.action;
    }
}

