/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.stream;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.plugins.mongo.buffer.RecordBufferWriter;
import org.opensearch.dataprepper.plugins.mongo.configuration.CollectionConfig;
import org.opensearch.dataprepper.plugins.mongo.configuration.MongoDBSourceConfig;
import org.opensearch.dataprepper.plugins.mongo.converter.PartitionKeyRecordConverter;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.StreamPartition;
import org.opensearch.dataprepper.plugins.mongo.stream.DataStreamPartitionCheckpoint;
import org.opensearch.dataprepper.plugins.mongo.stream.StreamAcknowledgementManager;
import org.opensearch.dataprepper.plugins.mongo.stream.StreamWorker;
import org.opensearch.dataprepper.plugins.mongo.utils.DocumentDBSourceAggregateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamScheduler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StreamScheduler.class);
    private static final int DEFAULT_TAKE_LEASE_INTERVAL_MILLIS = 60000;
    static final int DEFAULT_CHECKPOINT_INTERVAL_MILLS = 60000;
    static final int DEFAULT_BUFFER_WRITE_INTERVAL_MILLS = 5000;
    private static final int DEFAULT_MONITOR_WAIT_TIME_MS = 15000;
    static final int DEFAULT_BUFFER_BATCH_SIZE = 10;
    static final int DEFAULT_RECORD_FLUSH_BATCH_SIZE = 100;
    static final Duration BUFFER_TIMEOUT = Duration.ofSeconds(60L);
    private final EnhancedSourceCoordinator sourceCoordinator;
    private final RecordBufferWriter recordBufferWriter;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final MongoDBSourceConfig sourceConfig;
    private final String s3PathPrefix;
    private final PluginMetrics pluginMetrics;
    private final DocumentDBSourceAggregateMetrics documentDBAggregateMetrics;

    public StreamScheduler(EnhancedSourceCoordinator sourceCoordinator, Buffer<Record<Event>> buffer, AcknowledgementSetManager acknowledgementSetManager, MongoDBSourceConfig sourceConfig, String s3PathPrefix, PluginMetrics pluginMetrics, DocumentDBSourceAggregateMetrics documentDBAggregateMetrics) {
        this.sourceCoordinator = sourceCoordinator;
        BufferAccumulator bufferAccumulator = BufferAccumulator.create(buffer, (int)10, (Duration)BUFFER_TIMEOUT);
        this.recordBufferWriter = RecordBufferWriter.create((BufferAccumulator<Record<Event>>)bufferAccumulator, pluginMetrics);
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.sourceConfig = sourceConfig;
        Preconditions.checkArgument((boolean)Objects.nonNull(s3PathPrefix), (Object)"S3 path prefix must not be null");
        this.s3PathPrefix = s3PathPrefix;
        this.pluginMetrics = pluginMetrics;
        this.documentDBAggregateMetrics = documentDBAggregateMetrics;
    }

    @Override
    public void run() {
        StreamPartition streamPartition = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Optional sourcePartition = this.sourceCoordinator.acquireAvailablePartition("STREAM");
                if (sourcePartition.isPresent()) {
                    LOG.info("Acquired partition to read from streams");
                    if (this.sourceConfig.isDisableS3ReadForLeader()) {
                        System.setProperty("STOP_S3_SCAN_PROCESSING", "true");
                    }
                    streamPartition = (StreamPartition)((Object)sourcePartition.get());
                    StreamWorker streamWorker = this.getStreamWorker(streamPartition);
                    streamWorker.processStream(streamPartition);
                }
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("The StreamScheduler was interrupted while waiting to retry, stopping processing");
                }
            }
            catch (Exception e) {
                LOG.error("Received an exception during stream processing from DocumentDB, backing off and retrying", (Throwable)e);
                if (streamPartition != null) {
                    if (this.sourceConfig.isDisableS3ReadForLeader()) {
                        System.clearProperty("STOP_S3_SCAN_PROCESSING");
                    }
                    this.sourceCoordinator.giveUpPartition(streamPartition);
                }
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.info("The StreamScheduler was interrupted while waiting to retry, stopping processing");
                }
            }
            break;
        }
    }

    private StreamWorker getStreamWorker(StreamPartition streamPartition) {
        DataStreamPartitionCheckpoint partitionCheckpoint = new DataStreamPartitionCheckpoint(this.sourceCoordinator, streamPartition);
        StreamAcknowledgementManager streamAcknowledgementManager = new StreamAcknowledgementManager(this.acknowledgementSetManager, partitionCheckpoint, this.sourceConfig.getPartitionAcknowledgmentTimeout(), 15000, 60000, this.pluginMetrics);
        PartitionKeyRecordConverter recordConverter = this.getPartitionKeyRecordConverter(streamPartition);
        CollectionConfig partitionCollectionConfig = this.sourceConfig.getCollections().stream().filter(collectionConfig -> collectionConfig.getCollection().equals(streamPartition.getCollection())).findFirst().get();
        return StreamWorker.create(this.recordBufferWriter, recordConverter, this.sourceConfig, streamAcknowledgementManager, partitionCheckpoint, this.pluginMetrics, 100, 60000, 5000, partitionCollectionConfig.getStreamBatchSize(), this.documentDBAggregateMetrics);
    }

    private PartitionKeyRecordConverter getPartitionKeyRecordConverter(StreamPartition streamPartition) {
        String s3Prefix = this.s3PathPrefix + streamPartition.getCollection();
        return new PartitionKeyRecordConverter(streamPartition.getCollection(), "STREAM", s3Prefix);
    }
}

