/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.s3partition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.GlobalState;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.S3FolderPartition;
import org.opensearch.dataprepper.plugins.mongo.model.S3PartitionStatus;
import org.opensearch.dataprepper.plugins.mongo.s3partition.S3FolderPartitionCoordinator;
import org.opensearch.dataprepper.plugins.mongo.s3partition.S3PartitionCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PartitionCreatorScheduler
extends S3FolderPartitionCoordinator
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(S3PartitionCreatorScheduler.class);
    public static final String S3_FOLDER_PREFIX = "S3-FOLDER-";
    private static final int DEFAULT_TAKE_LEASE_INTERVAL_MILLIS = 60000;
    private final EnhancedSourceCoordinator sourceCoordinator;
    private final List<String> collections;

    public S3PartitionCreatorScheduler(EnhancedSourceCoordinator sourceCoordinator, List<String> collections) {
        super(sourceCoordinator);
        this.sourceCoordinator = sourceCoordinator;
        this.collections = new ArrayList<String>(collections);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Optional<S3PartitionStatus> s3PartitionStatus;
                Optional sourcePartition = this.sourceCoordinator.acquireAvailablePartition("S3_FOLDER");
                if (sourcePartition.isPresent()) {
                    S3FolderPartition s3FolderPartition = (S3FolderPartition)((Object)sourcePartition.get());
                    List<String> s3Folders = this.createS3BucketPartitions(s3FolderPartition.getPartitionCount());
                    this.sourceCoordinator.completePartition((EnhancedSourcePartition)s3FolderPartition);
                    s3PartitionStatus = new S3PartitionStatus(s3Folders);
                    this.sourceCoordinator.createPartition((EnhancedSourcePartition)new GlobalState(S3_FOLDER_PREFIX + s3FolderPartition.getCollection(), ((S3PartitionStatus)((Object)s3PartitionStatus)).toMap()));
                    break;
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    LOG.info("The S3 partition creator scheduler was interrupted while waiting to retry, stopping processing");
                    break;
                }
                Iterator<String> iterator = this.collections.iterator();
                while (iterator.hasNext()) {
                    String collection = iterator.next();
                    s3PartitionStatus = this.getGlobalS3FolderCreationStatus(collection);
                    if (!s3PartitionStatus.isPresent()) continue;
                    iterator.remove();
                }
                if (!this.collections.isEmpty()) continue;
                LOG.info("The S3 folder partition global state created for all collections.");
            }
            catch (Exception e) {
                LOG.error("Received an exception during creation of S3 partition folder, backing off and retrying", (Throwable)e);
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.info("The S3 partition creator scheduler was interrupted while waiting to retry, stopping processing");
                }
            }
            break;
        }
    }

    private List<String> createS3BucketPartitions(int partitionCount) {
        S3PartitionCreator s3PartitionCreator = new S3PartitionCreator(partitionCount);
        return s3PartitionCreator.createPartition();
    }
}

