/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.buffer;

import io.micrometer.core.instrument.Counter;
import java.util.List;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordBufferWriter {
    private static final Logger LOG = LoggerFactory.getLogger(RecordBufferWriter.class);
    static final String RECORDS_PROCESSED_COUNT = "recordsProcessed";
    static final String RECORDS_PROCESSING_ERROR_COUNT = "recordProcessingErrors";
    private final PluginMetrics pluginMetrics;
    private final Counter recordSuccessCounter;
    private final Counter recordErrorCounter;
    private final BufferAccumulator<Record<Event>> bufferAccumulator;

    private RecordBufferWriter(BufferAccumulator<Record<Event>> bufferAccumulator, PluginMetrics pluginMetrics) {
        this.bufferAccumulator = bufferAccumulator;
        this.pluginMetrics = pluginMetrics;
        this.recordSuccessCounter = pluginMetrics.counter(RECORDS_PROCESSED_COUNT);
        this.recordErrorCounter = pluginMetrics.counter(RECORDS_PROCESSING_ERROR_COUNT);
    }

    public static RecordBufferWriter create(BufferAccumulator<Record<Event>> bufferAccumulator, PluginMetrics pluginMetrics) {
        return new RecordBufferWriter(bufferAccumulator, pluginMetrics);
    }

    void flushBuffer() throws Exception {
        this.bufferAccumulator.flush();
    }

    public void addToBuffer(AcknowledgementSet acknowledgementSet, Event record) throws Exception {
        if (acknowledgementSet != null) {
            acknowledgementSet.add(record);
        }
        this.bufferAccumulator.add(new Record((Object)record));
    }

    public void writeToBuffer(AcknowledgementSet acknowledgementSet, List<Event> records) {
        int eventCount = 0;
        for (Event record : records) {
            try {
                this.addToBuffer(acknowledgementSet, record);
                ++eventCount;
            }
            catch (Exception e) {
                LOG.error("Failed to add event to buffer due to {}", (Object)e.getMessage());
            }
        }
        try {
            this.flushBuffer();
            this.recordSuccessCounter.increment((double)eventCount);
        }
        catch (Exception e) {
            LOG.error("Failed to write {} events to buffer due to {}", (Object)eventCount, (Object)e.getMessage());
            this.recordErrorCounter.increment((double)eventCount);
        }
    }
}

