/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.RetryHandler;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.auth.Office365AuthenticationInterface;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.models.AuditLogsResponse;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Named
public class Office365RestClient {
    private static final Logger log = LoggerFactory.getLogger(Office365RestClient.class);
    private static final String AUDIT_LOG_FETCH_LATENCY = "auditLogFetchLatency";
    private static final String SEARCH_CALL_LATENCY = "searchCallLatency";
    private static final String AUDIT_LOGS_REQUESTED = "auditLogsRequested";
    private static final String AUDIT_LOG_REQUESTS_FAILED = "auditLogRequestsFailed";
    private static final String AUDIT_LOG_REQUESTS_SUCCESS = "auditLogRequestsSuccess";
    private static final String SEARCH_REQUESTS_FAILED = "searchRequestsFailed";
    private static final String MANAGEMENT_API_BASE_URL = "https://manage.office.com/api/v1.0/";
    private final RestTemplate restTemplate = new RestTemplate();
    private final Office365AuthenticationInterface authConfig;
    private final Timer auditLogFetchLatencyTimer;
    private final Timer searchCallLatencyTimer;
    private final Counter auditLogsRequestedCounter;
    private final Counter auditLogRequestsFailedCounter;
    private final Counter auditLogRequestsSuccessCounter;
    private final Counter searchRequestsFailedCounter;

    public Office365RestClient(Office365AuthenticationInterface authConfig, PluginMetrics pluginMetrics) {
        this.authConfig = authConfig;
        this.auditLogFetchLatencyTimer = pluginMetrics.timer(AUDIT_LOG_FETCH_LATENCY);
        this.searchCallLatencyTimer = pluginMetrics.timer(SEARCH_CALL_LATENCY);
        this.auditLogsRequestedCounter = pluginMetrics.counter(AUDIT_LOGS_REQUESTED);
        this.auditLogRequestsFailedCounter = pluginMetrics.counter(AUDIT_LOG_REQUESTS_FAILED);
        this.auditLogRequestsSuccessCounter = pluginMetrics.counter(AUDIT_LOG_REQUESTS_SUCCESS);
        this.searchRequestsFailedCounter = pluginMetrics.counter(SEARCH_REQUESTS_FAILED);
    }

    public void startSubscriptions() {
        log.info("Starting Office 365 subscriptions for audit logs");
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setContentLength(0L);
            for (String contentType : Constants.CONTENT_TYPES) {
                String SUBSCRIPTION_START_URL = "https://manage.office.com/api/v1.0/%s/activity/feed/subscriptions/start?contentType=%s";
                String url = String.format("https://manage.office.com/api/v1.0/%s/activity/feed/subscriptions/start?contentType=%s", this.authConfig.getTenantId(), contentType);
                RetryHandler.executeWithRetry(() -> {
                    try {
                        headers.setBearerAuth(this.authConfig.getAccessToken());
                        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
                        log.debug("Started subscription for {}: {}", (Object)contentType, response.getBody());
                        return response;
                    }
                    catch (HttpClientErrorException e) {
                        if (e.getResponseBodyAsString().contains("AF20024")) {
                            log.debug("Subscription for {} is already enabled", (Object)contentType);
                            return null;
                        }
                        throw e;
                    }
                }, this.authConfig::renewCredentials);
            }
        }
        catch (HttpClientErrorException e) {
            log.error(DataPrepperMarkers.NOISY, "Failed to initialize subscriptions with status code {}: {}", (Object)e.getStatusCode(), (Object)e.getMessage());
            throw new RuntimeException("Failed to initialize subscriptions: " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.error(DataPrepperMarkers.NOISY, "Failed to initialize subscriptions", (Throwable)e);
            throw new RuntimeException("Failed to initialize subscriptions", e);
        }
    }

    public AuditLogsResponse searchAuditLogs(String contentType, Instant startTime, Instant endTime, String pageUri) {
        String GET_AUDIT_LOGS_URL = "https://manage.office.com/api/v1.0/%s/activity/feed/subscriptions/content?contentType=%s&startTime=%s&endTime=%s";
        String url = pageUri != null ? pageUri : String.format("https://manage.office.com/api/v1.0/%s/activity/feed/subscriptions/content?contentType=%s&startTime=%s&endTime=%s", this.authConfig.getTenantId(), contentType, startTime.toString(), endTime.toString());
        HttpHeaders headers = new HttpHeaders();
        return (AuditLogsResponse)this.searchCallLatencyTimer.record(() -> {
            try {
                return RetryHandler.executeWithRetry(() -> {
                    String nextPageUri;
                    headers.setBearerAuth(this.authConfig.getAccessToken());
                    ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<List<Map<String, Object>>>(){}, new Object[0]);
                    List nextPageHeaders = response.getHeaders().get((Object)"NextPageUri");
                    String string = nextPageUri = nextPageHeaders != null && !nextPageHeaders.isEmpty() ? (String)nextPageHeaders.get(0) : null;
                    if (nextPageUri != null) {
                        log.debug("Next page URI found: {}", (Object)nextPageUri);
                    }
                    return new AuditLogsResponse((List)response.getBody(), nextPageUri);
                }, this.authConfig::renewCredentials);
            }
            catch (Exception e) {
                log.error(DataPrepperMarkers.NOISY, "Error while fetching audit logs for content type {}", (Object)contentType, (Object)e);
                this.searchRequestsFailedCounter.increment();
                throw new RuntimeException("Failed to fetch audit logs", e);
            }
        });
    }

    public String getAuditLog(String contentId) {
        this.auditLogsRequestedCounter.increment();
        String FETCH_AUDIT_LOG_URL = "https://manage.office.com/api/v1.0/%s/activity/feed/audit/%s";
        String url = String.format("https://manage.office.com/api/v1.0/%s/activity/feed/audit/%s", this.authConfig.getTenantId(), contentId);
        HttpHeaders headers = new HttpHeaders();
        return (String)this.auditLogFetchLatencyTimer.record(() -> {
            try {
                String response = RetryHandler.executeWithRetry(() -> {
                    headers.setBearerAuth(this.authConfig.getAccessToken());
                    return (String)this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]).getBody();
                }, this.authConfig::renewCredentials);
                this.auditLogRequestsSuccessCounter.increment();
                return response;
            }
            catch (Exception e) {
                log.error(DataPrepperMarkers.NOISY, "Error while fetching audit log with ID {}", (Object)contentId, (Object)e);
                this.auditLogRequestsFailedCounter.increment();
                throw new RuntimeException("Failed to fetch audit log", e);
            }
        });
    }
}

