/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.stream.Stream;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaRegistryType;

public class SchemaConfig {
    private static final int SESSION_TIME_OUT = 45000;
    @JsonProperty(value="type")
    private SchemaRegistryType type;
    @JsonProperty(value="registry_url")
    private String registryURL;
    @JsonProperty(value="override_endpoint")
    private Boolean overrideEndpoint = false;
    @JsonProperty(value="version")
    private Integer version;
    @JsonAlias(value={"schema_registry_api_key"})
    @JsonProperty(value="api_key")
    private String schemaRegistryApiKey;
    @JsonAlias(value={"schema_registry_api_secret"})
    @JsonProperty(value="api_secret")
    private String schemaRegistryApiSecret;
    @JsonProperty(value="session_timeout_ms")
    private int sessionTimeoutms = 45000;
    @JsonProperty(value="basic_auth_credentials_source")
    private String basicAuthCredentialsSource;
    @JsonProperty(value="inline_schema")
    private String inlineSchema;
    @JsonProperty(value="schema_file_location")
    private String schemaFileLocation;
    @JsonProperty(value="s3_file_config")
    private S3FileConfig s3FileConfig;
    @JsonProperty(value="is_schema_create")
    @NotNull
    private Boolean isSchemaCreate = Boolean.FALSE;

    public int getSessionTimeoutms() {
        return this.sessionTimeoutms;
    }

    public boolean getOverrideEndpoint() {
        return this.overrideEndpoint;
    }

    public String getBasicAuthCredentialsSource() {
        return this.basicAuthCredentialsSource;
    }

    public String getRegistryURL() {
        return this.registryURL;
    }

    public Integer getVersion() {
        return this.version;
    }

    public SchemaRegistryType getType() {
        return this.type;
    }

    public String getSchemaRegistryApiKey() {
        return this.schemaRegistryApiKey;
    }

    public String getSchemaRegistryApiSecret() {
        return this.schemaRegistryApiSecret;
    }

    public String getInlineSchema() {
        return this.inlineSchema;
    }

    public String getSchemaFileLocation() {
        return this.schemaFileLocation;
    }

    public S3FileConfig getS3FileConfig() {
        return this.s3FileConfig;
    }

    @AssertTrue(message="Only one of Inline schema or Schema file location or S3 file config  must be specified")
    public @AssertTrue(message="Only one of Inline schema or Schema file location or S3 file config  must be specified") boolean hasOnlyOneConfig() {
        if (this.isSchemaCreate.booleanValue()) {
            return Stream.of(this.inlineSchema, this.schemaFileLocation, this.s3FileConfig).filter(n -> n != null).count() == 1L;
        }
        return true;
    }

    public Boolean isCreate() {
        return this.isSchemaCreate;
    }

    public static class S3FileConfig {
        @Valid
        @Size(max=0, message="bucket is mandatory.")
        @JsonProperty(value="bucket_name")
        private @Valid @Size(max=0, message="bucket is mandatory.") String bucketName;
        @Valid
        @Size(max=0, message="file key is mandatory.")
        @JsonProperty(value="file_key")
        private @Valid @Size(max=0, message="file key is mandatory.") String fileKey;
        @Valid
        @Size(max=0, message="region is mandatory")
        @JsonProperty(value="region")
        private @Valid @Size(max=0, message="region is mandatory") String region;

        public String getRegion() {
            return this.region;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getFileKey() {
            return this.fileKey;
        }
    }
}

