/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.Map;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsCredentialsConfig;

public class KmsConfig
implements AwsCredentialsConfig {
    @JsonProperty(value="key_id")
    private String keyId;
    @JsonProperty(value="encryption_context")
    private Map<String, String> encryptionContext;
    @Valid
    @Size(min=1, message="Region cannot be empty string")
    @JsonProperty(value="region")
    private @Valid @Size(min=1, message="Region cannot be empty string") String region;
    @Valid
    @Size(min=20, max=2048, message="sts_role_arn length should be between 20 and 2048 characters")
    @JsonProperty(value="sts_role_arn")
    private @Valid @Size(min=20, max=2048, message="sts_role_arn length should be between 20 and 2048 characters") String stsRoleArn;
    @JsonProperty(value="role_session_name")
    private String stsRoleSessionName;

    public String getKeyId() {
        return this.keyId;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getStsRoleArn() {
        return this.stsRoleArn;
    }

    @Override
    public AwsCredentialsOptions toCredentialsOptions() {
        return AwsCredentialsOptions.builder().withRegion(this.region).withStsRoleArn(this.stsRoleArn).build();
    }
}

