/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.thread;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.MDC;

public class KafkaPluginThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegateThreadFactory;
    private final String threadPrefix;
    private final String kafkaPluginType;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    KafkaPluginThreadFactory(ThreadFactory delegateThreadFactory, String kafkaPluginType) {
        this.delegateThreadFactory = delegateThreadFactory;
        this.threadPrefix = KafkaPluginThreadFactory.createPluginPart(kafkaPluginType);
        this.kafkaPluginType = kafkaPluginType;
    }

    KafkaPluginThreadFactory(ThreadFactory delegateThreadFactory, String kafkaPluginType, String kafkaTopic) {
        this.delegateThreadFactory = delegateThreadFactory;
        this.threadPrefix = KafkaPluginThreadFactory.normalizeName(kafkaTopic) + "-" + KafkaPluginThreadFactory.createPluginPart(kafkaPluginType);
        this.kafkaPluginType = kafkaPluginType;
    }

    public static KafkaPluginThreadFactory defaultExecutorThreadFactory(String kafkaPluginType) {
        return new KafkaPluginThreadFactory(Executors.defaultThreadFactory(), kafkaPluginType);
    }

    public static KafkaPluginThreadFactory defaultExecutorThreadFactory(String kafkaPluginType, String kafkaTopic) {
        return new KafkaPluginThreadFactory(Executors.defaultThreadFactory(), kafkaPluginType, kafkaTopic);
    }

    private static String createPluginPart(String kafkaPluginType) {
        return "kafka-" + kafkaPluginType + "-";
    }

    private static String normalizeName(String kafkaTopic) {
        String limitedName = kafkaTopic.length() > 20 ? kafkaTopic.substring(0, 20) : kafkaTopic;
        return limitedName.toLowerCase().replaceAll("[^a-z0-9]", "-");
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.delegateThreadFactory.newThread(() -> {
            MDC.put((String)"kafkaPluginType", (String)this.kafkaPluginType);
            try {
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        });
        thread.setName(this.threadPrefix + this.threadNumber.getAndIncrement());
        return thread;
    }
}

