/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.key;

import java.util.Base64;
import org.opensearch.dataprepper.plugins.kafka.common.aws.AwsContext;
import org.opensearch.dataprepper.plugins.kafka.common.key.InnerKeyProvider;
import org.opensearch.dataprepper.plugins.kafka.configuration.KmsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.model.DecryptResponse;

class KmsKeyProvider
implements InnerKeyProvider {
    private final AwsContext awsContext;

    public KmsKeyProvider(AwsContext awsContext) {
        this.awsContext = awsContext;
    }

    @Override
    public boolean supportsConfiguration(TopicConfig topicConfig) {
        return topicConfig.getKmsConfig() != null && topicConfig.getKmsConfig().getKeyId() != null;
    }

    @Override
    public boolean isKeyEncrypted() {
        return true;
    }

    @Override
    public byte[] apply(TopicConfig topicConfig) {
        KmsConfig kmsConfig = topicConfig.getKmsConfig();
        String kmsKeyId = kmsConfig.getKeyId();
        AwsCredentialsProvider awsCredentialsProvider = this.awsContext.getOrDefault(kmsConfig);
        KmsClient kmsClient = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().credentialsProvider(awsCredentialsProvider)).region(this.awsContext.getRegionOrDefault(kmsConfig))).build();
        byte[] decodedEncryptionKey = Base64.getDecoder().decode(topicConfig.getEncryptionKey());
        DecryptResponse decryptResponse = kmsClient.decrypt(builder -> builder.keyId(kmsKeyId).ciphertextBlob(SdkBytes.fromByteArray((byte[])decodedEncryptionKey)).encryptionContext(kmsConfig.getEncryptionContext()));
        return decryptResponse.plaintext().asByteArray();
    }
}

