/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.buffer.serialization;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.kafka.common.serialization.Deserializer;
import org.opensearch.dataprepper.model.encryption.EncryptionEngine;
import org.opensearch.dataprepper.model.encryption.EncryptionEnvelope;
import org.opensearch.dataprepper.plugins.encryption.DefaultEncryptionEnvelope;
import org.opensearch.dataprepper.plugins.kafka.buffer.KafkaBufferMessage;

class BufferMessageEncryptionDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> dataDeserializer;
    private final EncryptionEngine encryptionEngine;

    public BufferMessageEncryptionDeserializer(Deserializer<T> dataDeserializer, EncryptionEngine encryptionEngine) {
        this.dataDeserializer = dataDeserializer;
        this.encryptionEngine = encryptionEngine;
    }

    public T deserialize(String topic, byte[] data) {
        KafkaBufferMessage.BufferData bufferedData;
        try {
            bufferedData = KafkaBufferMessage.BufferData.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        byte[] dataBytes = this.encryptionEngine.decrypt((EncryptionEnvelope)DefaultEncryptionEnvelope.builder().encryptedDataKey(bufferedData.getEncryptedDataKey().toStringUtf8()).encryptedData(bufferedData.getData().toByteArray()).build());
        return (T)this.dataDeserializer.deserialize(topic, dataBytes);
    }

    Deserializer<T> getDataDeserializer() {
        return this.dataDeserializer;
    }
}

