/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.buffer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.kafka.configuration.CommonTopicConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaKeyMode;
import org.opensearch.dataprepper.plugins.kafka.configuration.KmsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConsumerConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicProducerConfig;
import org.opensearch.dataprepper.plugins.kafka.util.MessageFormat;

class BufferTopicConfig
extends CommonTopicConfig
implements TopicProducerConfig,
TopicConsumerConfig {
    static final Duration DEFAULT_COMMIT_INTERVAL = Duration.ofSeconds(5L);
    private static final Integer DEFAULT_NUM_OF_PARTITIONS = 1;
    private static final Short DEFAULT_REPLICATION_FACTOR = 1;
    private static final Long DEFAULT_RETENTION_PERIOD = 604800000L;
    static final boolean DEFAULT_AUTO_COMMIT = false;
    static final ByteCount DEFAULT_FETCH_MAX_BYTES = ByteCount.parse((String)"50mb");
    static final Duration DEFAULT_FETCH_MAX_WAIT = Duration.ofMillis(1000L);
    static final ByteCount DEFAULT_FETCH_MIN_BYTES = ByteCount.parse((String)"2kb");
    static final ByteCount DEFAULT_MAX_PARTITION_FETCH_BYTES = ByteCount.parse((String)"1mb");
    static final Duration DEFAULT_SESSION_TIMEOUT = Duration.ofSeconds(45L);
    static final String DEFAULT_AUTO_OFFSET_RESET = "earliest";
    static final Duration DEFAULT_THREAD_WAITING_TIME = Duration.ofSeconds(5L);
    static final Duration DEFAULT_MAX_POLL_INTERVAL = Duration.ofSeconds(300L);
    static final Integer DEFAULT_CONSUMER_MAX_POLL_RECORDS = 500;
    static final Integer DEFAULT_NUM_OF_WORKERS = 2;
    static final Duration DEFAULT_HEART_BEAT_INTERVAL_DURATION = Duration.ofSeconds(5L);
    @JsonProperty(value="encryption_id")
    private String encryptionId;
    @JsonProperty(value="encryption_key")
    private String encryptionKey;
    @JsonProperty(value="kms")
    private KmsConfig kmsConfig;
    @JsonProperty(value="commit_interval")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) Duration commitInterval = DEFAULT_COMMIT_INTERVAL;
    @JsonProperty(value="number_of_partitions")
    private Integer numberOfPartitions = DEFAULT_NUM_OF_PARTITIONS;
    @JsonProperty(value="replication_factor")
    private Short replicationFactor = DEFAULT_REPLICATION_FACTOR;
    @JsonProperty(value="retention_period")
    private Long retentionPeriod = DEFAULT_RETENTION_PERIOD;
    @JsonProperty(value="create_topic")
    private boolean isCreateTopic = false;
    @JsonProperty(value="group_id")
    @Valid
    @Size(min=1, max=255, message="size of group id should be between 1 and 255")
    private @Valid @Size(min=1, max=255, message="size of group id should be between 1 and 255") String groupId;
    @JsonProperty(value="client_id")
    @Valid
    @Size(min=1, max=255, message="size of client id should be between 1 and 255")
    private @Valid @Size(min=1, max=255, message="size of client id should be between 1 and 255") String clientId;
    @JsonProperty(value="workers")
    @Valid
    @Size(min=1, max=200, message="Number of worker threads should lies between 1 and 200")
    private @Valid @Size(min=1, max=200, message="Number of worker threads should lies between 1 and 200") Integer workers = DEFAULT_NUM_OF_WORKERS;
    @JsonProperty(value="session_timeout")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) Duration sessionTimeOut = DEFAULT_SESSION_TIMEOUT;
    @JsonProperty(value="auto_offset_reset")
    private String autoOffsetReset = "earliest";
    @JsonProperty(value="thread_waiting_time")
    private Duration threadWaitingTime = DEFAULT_THREAD_WAITING_TIME;
    @JsonProperty(value="max_poll_interval")
    private Duration maxPollInterval = DEFAULT_MAX_POLL_INTERVAL;
    @JsonProperty(value="consumer_max_poll_records")
    private Integer consumerMaxPollRecords = DEFAULT_CONSUMER_MAX_POLL_RECORDS;
    @JsonProperty(value="heart_beat_interval")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) Duration heartBeatInterval = DEFAULT_HEART_BEAT_INTERVAL_DURATION;
    @JsonProperty(value="auto_commit")
    private Boolean autoCommit = false;
    @JsonProperty(value="max_partition_fetch_bytes")
    private ByteCount maxPartitionFetchBytes = DEFAULT_MAX_PARTITION_FETCH_BYTES;
    @JsonProperty(value="fetch_max_bytes")
    private ByteCount fetchMaxBytes = DEFAULT_FETCH_MAX_BYTES;
    @JsonProperty(value="fetch_max_wait")
    @Valid
    private Duration fetchMaxWait = DEFAULT_FETCH_MAX_WAIT;
    @JsonProperty(value="fetch_min_bytes")
    private ByteCount fetchMinBytes = DEFAULT_FETCH_MIN_BYTES;

    BufferTopicConfig() {
    }

    @Override
    @JsonIgnore
    public MessageFormat getSerdeFormat() {
        return MessageFormat.BYTES;
    }

    @Override
    public String getEncryptionId() {
        return this.encryptionId;
    }

    @Override
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public KmsConfig getKmsConfig() {
        return this.kmsConfig;
    }

    @Override
    @JsonIgnore
    public KafkaKeyMode getKafkaKeyMode() {
        return KafkaKeyMode.DISCARD;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public Duration getCommitInterval() {
        return this.commitInterval;
    }

    @Override
    public Integer getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    @Override
    public Short getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public Long getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @Override
    @JsonIgnore
    public boolean isCreateTopic() {
        return this.isCreateTopic;
    }

    @Override
    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public Duration getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    @Override
    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    @Override
    public Duration getThreadWaitingTime() {
        return this.threadWaitingTime;
    }

    @Override
    public Duration getMaxPollInterval() {
        return this.maxPollInterval;
    }

    @Override
    public Integer getConsumerMaxPollRecords() {
        return this.consumerMaxPollRecords;
    }

    @Override
    public Integer getWorkers() {
        return this.workers;
    }

    @Override
    public Duration getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public long getFetchMaxBytes() {
        long value = this.fetchMaxBytes.getBytes();
        if (value < 1L || value > 0x3200000L) {
            throw new RuntimeException("Invalid Fetch Max Bytes");
        }
        return value;
    }

    @Override
    public Integer getFetchMaxWait() {
        return Math.toIntExact(this.fetchMaxWait.toMillis());
    }

    @Override
    public long getFetchMinBytes() {
        long value = this.fetchMinBytes.getBytes();
        if (value < 1L) {
            throw new RuntimeException("Invalid Fetch Min Bytes");
        }
        return value;
    }

    @Override
    public long getMaxPartitionFetchBytes() {
        return this.maxPartitionFetchBytes.getBytes();
    }

    @AssertTrue(message="Either encryption_id or encryption_key together with kms_config must be specified, and only one of them can be specified")
    public @AssertTrue(message="Either encryption_id or encryption_key together with kms_config must be specified, and only one of them can be specified") boolean IsEncryptionAtRestSettingValid() {
        return this.encryptionId == null || this.encryptionKey == null && this.kmsConfig == null;
    }

    public boolean encryptionAtRestEnabled() {
        return this.encryptionId != null || this.encryptionKey != null || this.kmsConfig != null;
    }
}

