/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class IssueBean {
    @JsonProperty(value="expand")
    private String expand = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="self")
    private String self = null;
    @JsonProperty(value="key")
    private String key = null;
    @JsonProperty(value="renderedFields")
    private Map<String, Object> renderedFields = null;
    @JsonProperty(value="properties")
    private Map<String, Object> properties = null;
    @JsonProperty(value="names")
    private Map<String, String> names = null;
    @JsonProperty(value="fields")
    private Map<String, Object> fields = null;
    @JsonIgnore
    private final Pattern JiraDateTimePattern = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[-+]\\d{4}$");
    @JsonIgnore
    private final DateTimeFormatter offsetDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    @JsonIgnore
    public String getProject() {
        if (this.fields != null && Objects.nonNull(((Map)this.fields.get("project")).get("key"))) {
            return ((Map)this.fields.get("project")).get("key").toString();
        }
        return null;
    }

    @JsonIgnore
    public String getProjectName() {
        if (this.fields != null && Objects.nonNull(((Map)this.fields.get("project")).get("name"))) {
            return ((Map)this.fields.get("project")).get("name").toString();
        }
        return null;
    }

    @JsonIgnore
    public long getCreatedTimeMillis() {
        return this.getGivenDateField("created");
    }

    @JsonIgnore
    public long getUpdatedTimeMillis() {
        return this.getGivenDateField("updated");
    }

    @JsonIgnore
    private long getGivenDateField(String dateTimeFieldToPull) {
        long dateTimeField = 0L;
        if (this.fields != null && Objects.nonNull(this.fields.get(dateTimeFieldToPull)) && this.JiraDateTimePattern.matcher(this.fields.get(dateTimeFieldToPull).toString()).matches()) {
            String charSequence = this.fields.get(dateTimeFieldToPull).toString();
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(charSequence, this.offsetDateTimeFormatter);
            dateTimeField = offsetDateTime.toInstant().toEpochMilli();
        }
        return dateTimeField;
    }

    public String getExpand() {
        return this.expand;
    }

    @JsonProperty(value="expand")
    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public String getSelf() {
        return this.self;
    }

    @JsonProperty(value="self")
    public void setSelf(String self) {
        this.self = self;
    }

    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public Map<String, Object> getRenderedFields() {
        return this.renderedFields;
    }

    @JsonProperty(value="renderedFields")
    public void setRenderedFields(Map<String, Object> renderedFields) {
        this.renderedFields = renderedFields;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    @JsonProperty(value="names")
    public void setNames(Map<String, String> names) {
        this.names = names;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }
}

