/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Base64;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeyWriter;
import org.opensearch.dataprepper.plugins.encryption.EncryptionRotationHandler;
import org.opensearch.dataprepper.plugins.encryption.KmsEncryptionEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DataKeySpec;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse;

class KmsEncryptionRotationHandler
implements EncryptionRotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KmsEncryptionRotationHandler.class);
    static final String ENCRYPTION_ROTATION_SUCCESS = "encryptionRotationSuccess";
    static final String ENCRYPTION_ROTATION_FAILURE = "encryptionRotationFailure";
    static final String ENCRYPTION_ROTATION_DURATION = "encryptionRotationDuration";
    static final String ENCRYPTION_ID_TAG = "encryptionId";
    private final String encryptionId;
    private final KmsClient kmsClient;
    private final KmsEncryptionEngineConfiguration kmsEncryptionEngineConfiguration;
    private final EncryptedDataKeyWriter encryptedDataKeyWriter;
    private final PluginMetrics pluginMetrics;
    private final Counter encryptionRotationSuccessCounter;
    private final Counter encryptionRotationFailureCounter;
    private final Timer encryptionRotationTimer;

    public KmsEncryptionRotationHandler(String encryptionId, KmsEncryptionEngineConfiguration kmsEncryptionEngineConfiguration, EncryptedDataKeyWriter encryptedDataKeyWriter, PluginMetrics pluginMetrics) {
        this.encryptionId = encryptionId;
        this.kmsEncryptionEngineConfiguration = kmsEncryptionEngineConfiguration;
        this.kmsClient = kmsEncryptionEngineConfiguration.createKmsClient();
        this.encryptedDataKeyWriter = encryptedDataKeyWriter;
        this.pluginMetrics = pluginMetrics;
        this.encryptionRotationSuccessCounter = pluginMetrics.counterWithTags(ENCRYPTION_ROTATION_SUCCESS, new String[]{ENCRYPTION_ID_TAG, encryptionId});
        this.encryptionRotationFailureCounter = pluginMetrics.counterWithTags(ENCRYPTION_ROTATION_FAILURE, new String[]{ENCRYPTION_ID_TAG, encryptionId});
        this.encryptionRotationTimer = pluginMetrics.timerWithTags(ENCRYPTION_ROTATION_DURATION, new String[]{ENCRYPTION_ID_TAG, encryptionId});
    }

    @Override
    public String getEncryptionId() {
        return this.encryptionId;
    }

    @Override
    public void handleRotation() {
        this.encryptionRotationTimer.record(() -> {
            try {
                String encodedEncryptedDataKey = this.generateNewEncodedEncryptedDataKey();
                this.encryptedDataKeyWriter.writeEncryptedDataKey(encodedEncryptedDataKey);
                this.encryptionRotationSuccessCounter.increment();
            }
            catch (Exception e) {
                LOG.error("Failed to rotate encrypted data key in encryption: {}.", (Object)this.encryptionId, (Object)e);
                this.encryptionRotationFailureCounter.increment();
            }
        });
    }

    private String generateNewEncodedEncryptedDataKey() {
        GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest = (GenerateDataKeyWithoutPlaintextRequest)GenerateDataKeyWithoutPlaintextRequest.builder().keyId(this.kmsEncryptionEngineConfiguration.getKeyId()).encryptionContext(this.kmsEncryptionEngineConfiguration.getEncryptionContext()).keySpec(DataKeySpec.AES_256).build();
        GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintextResponse = this.kmsClient.generateDataKeyWithoutPlaintext(generateDataKeyWithoutPlaintextRequest);
        byte[] encryptedDataKey = generateDataKeyWithoutPlaintextResponse.ciphertextBlob().asByteArray();
        return Base64.getEncoder().withoutPadding().encodeToString(encryptedDataKey);
    }
}

