/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

class S3BucketAndPrefix {
    static final String S3_PREFIX = "s3://";
    private final String bucketName;
    private final String prefix;

    public S3BucketAndPrefix(String bucketName, String prefix) {
        this.bucketName = bucketName;
        this.prefix = prefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static S3BucketAndPrefix fromS3Uri(String s3Uri) {
        String bucketName;
        if (s3Uri == null || !s3Uri.startsWith(S3_PREFIX)) {
            throw new IllegalArgumentException("Invalid S3 URI: " + s3Uri);
        }
        String withoutScheme = s3Uri.substring(S3_PREFIX.length());
        int firstSlashIndex = withoutScheme.indexOf("/");
        String prefix = "";
        if (firstSlashIndex == -1) {
            bucketName = withoutScheme;
        } else {
            bucketName = withoutScheme.substring(0, firstSlashIndex);
            prefix = withoutScheme.substring(firstSlashIndex + 1);
        }
        return new S3BucketAndPrefix(bucketName, prefix);
    }
}

