/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.KmsEncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.LocalDirectoryEncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.S3EncryptedDataKeySupplier;
import org.opensearch.dataprepper.plugins.encryption.StaticEncryptedDataKeySupplier;
import software.amazon.awssdk.services.s3.S3Client;

class EncryptedDataKeySupplierFactory {
    public static EncryptedDataKeySupplierFactory create() {
        return new EncryptedDataKeySupplierFactory();
    }

    private EncryptedDataKeySupplierFactory() {
    }

    public EncryptedDataKeySupplier createEncryptedDataKeySupplier(EncryptionEngineConfiguration encryptionEngineConfiguration) {
        if (encryptionEngineConfiguration instanceof KmsEncryptionEngineConfiguration) {
            return this.createKmsEncryptedDataKeySupplier((KmsEncryptionEngineConfiguration)encryptionEngineConfiguration);
        }
        throw new IllegalArgumentException(String.format("Unsupported encryption engine configuration: %s.", encryptionEngineConfiguration.name()));
    }

    private EncryptedDataKeySupplier createKmsEncryptedDataKeySupplier(KmsEncryptionEngineConfiguration kmsEncryptionEngineConfiguration) {
        if (kmsEncryptionEngineConfiguration.getEncryptionKey() != null) {
            return new StaticEncryptedDataKeySupplier(kmsEncryptionEngineConfiguration.getEncryptionKey());
        }
        if (kmsEncryptionEngineConfiguration.isEncryptionKeyInS3()) {
            S3Client s3Client = kmsEncryptionEngineConfiguration.createS3Client();
            return new S3EncryptedDataKeySupplier(s3Client, kmsEncryptionEngineConfiguration.getEncryptionKeyDirectory());
        }
        return new LocalDirectoryEncryptedDataKeySupplier(kmsEncryptionEngineConfiguration.getEncryptionKeyDirectory());
    }
}

