/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotBlank;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.regions.Region;

public class ExportConfig {
    @JsonProperty(value="s3_bucket")
    @NotBlank(message="Bucket Name is required for export")
    private @NotBlank(message="Bucket Name is required for export") String s3Bucket;
    @JsonProperty(value="s3_prefix")
    private String s3Prefix;
    @JsonProperty(value="s3_region")
    private String s3Region;
    @JsonProperty(value="s3_sse_kms_key_id")
    private String s3SseKmsKeyId;

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getS3Prefix() {
        return this.s3Prefix;
    }

    public Region getAwsRegion() {
        return this.s3Region != null ? Region.of((String)this.s3Region) : null;
    }

    public String getS3SseKmsKeyId() {
        return this.s3SseKmsKeyId;
    }

    @AssertTrue(message="KMS Key ID must be a valid one.")
    @AssertTrue(message="KMS Key ID must be a valid one.") boolean isKmsKeyIdValid() {
        return this.s3SseKmsKeyId == null || Arn.fromString((String)this.s3SseKmsKeyId).resourceAsString() != null;
    }
}

