/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.stream;

import java.time.Duration;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition.StreamPartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.state.StreamProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCheckpointer {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCheckpointer.class);
    static final Duration CHECKPOINT_OWNERSHIP_TIMEOUT_INCREASE = Duration.ofMinutes(10L);
    private final EnhancedSourceCoordinator coordinator;
    private final StreamPartition streamPartition;

    public StreamCheckpointer(EnhancedSourceCoordinator coordinator, StreamPartition streamPartition) {
        this.coordinator = coordinator;
        this.streamPartition = streamPartition;
    }

    private void setSequenceNumber(String sequenceNumber) {
        Optional<StreamProgressState> progressState;
        if (sequenceNumber != null && !sequenceNumber.isEmpty() && (progressState = this.streamPartition.getProgressState()).isPresent()) {
            progressState.get().setSequenceNumber(sequenceNumber);
        }
    }

    public void checkpoint(String sequenceNumber) {
        LOG.debug("Checkpoint shard " + this.streamPartition.getShardId() + " with sequenceNumber " + sequenceNumber);
        this.setSequenceNumber(sequenceNumber);
        this.coordinator.saveProgressStateForPartition((EnhancedSourcePartition)this.streamPartition, CHECKPOINT_OWNERSHIP_TIMEOUT_INCREASE);
    }

    public boolean isExportDone() {
        Optional globalPartition = this.coordinator.getPartition(this.streamPartition.getStreamArn());
        return globalPartition.isPresent();
    }

    public void updateShardForAcknowledgmentWait(Duration acknowledgmentSetTimeout) {
        this.coordinator.saveProgressStateForPartition((EnhancedSourcePartition)this.streamPartition, acknowledgmentSetTimeout);
    }
}

