/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.confluence.utils;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.confluence.ConfluenceSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.AddressValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceConfigHelper.class);

    public static List<String> getContentTypeIncludeFilter(ConfluenceSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getPageTypeConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getPageTypeConfig().getInclude();
    }

    public static List<String> getContentTypeExcludeFilter(ConfluenceSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getPageTypeConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getPageTypeConfig().getExclude();
    }

    public static List<String> getSpacesNameIncludeFilter(ConfluenceSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getSpaceConfig() == null || repositoryConfiguration.getFilterConfig().getSpaceConfig().getNameConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getSpaceConfig().getNameConfig().getInclude();
    }

    public static List<String> getSpacesNameExcludeFilter(ConfluenceSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getSpaceConfig() == null || repositoryConfiguration.getFilterConfig().getSpaceConfig().getNameConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getSpaceConfig().getNameConfig().getExclude();
    }

    public static boolean validateConfig(ConfluenceSourceConfig config) {
        if (config.getAccountUrl() == null) {
            throw new RuntimeException("Account URL is missing.");
        }
        if (config.getAuthType() == null) {
            throw new RuntimeException("Authentication Type is missing.");
        }
        String authType = config.getAuthType();
        if (!"OAuth2".equals(authType) && !"Basic".equals(authType)) {
            throw new RuntimeException("Invalid AuthType is given");
        }
        if ("Basic".equals(authType) && (config.getAuthenticationConfig().getBasicConfig().getUsername() == null || config.getAuthenticationConfig().getBasicConfig().getPassword() == null)) {
            throw new RuntimeException("Confluence ID or Credential are required for Basic AuthType");
        }
        if ("OAuth2".equals(authType) && (config.getAuthenticationConfig().getOauth2Config().getAccessToken() == null || config.getAuthenticationConfig().getOauth2Config().getRefreshToken() == null)) {
            throw new RuntimeException("Access Token or Refresh Token are required for OAuth2 AuthType");
        }
        AddressValidation.validateInetAddress((InetAddress)AddressValidation.getInetAddress((String)config.getAccountUrl()));
        return true;
    }
}

