/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Duration;
import java.util.Collection;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="delay", pluginType=Processor.class, pluginConfigurationType=Configuration.class)
public class DelayProcessor
implements Processor<Record<?>, Record<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DelayProcessor.class);
    private final Duration delayDuration;

    @DataPrepperPluginConstructor
    public DelayProcessor(Configuration configuration) {
        this.delayDuration = configuration.getDelayFor();
        LOG.info("Delay processor configured for {}. The pipeline will delay for this time. This is typically only for testing or debugging.", (Object)this.delayDuration);
    }

    public Collection<Record<?>> execute(Collection<Record<?>> records) {
        try {
            Thread.sleep(this.delayDuration.toMillis());
        }
        catch (InterruptedException ex) {
            LOG.error(DataPrepperMarkers.NOISY, "Interrupted during delay processor", (Throwable)ex);
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    @JsonPropertyOrder
    @JsonClassDescription(value="This processor will add a delay into the processor chain. Typically, you should use this only for testing, experimenting, and debugging.")
    public static class Configuration {
        @JsonProperty(value="for")
        @JsonPropertyDescription(value="The duration of time to delay. Defaults to <code>1s</code>.")
        @ExampleValues(value={@ExampleValues.Example(value="1s", description="Delays for 1 second."), @ExampleValues.Example(value="1000ms", description="Delays for 1,000 milliseconds."), @ExampleValues.Example(value="PT10M", description="Delays for 10 minutes.")})
        private Duration delayFor = Duration.ofSeconds(1L);

        public Duration getDelayFor() {
            return this.delayFor;
        }
    }
}

