/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.certificate.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCertificateProvider
implements CertificateProvider {
    private final String certificateFilePath;
    private final String privateKeyFilePath;
    private static final Logger LOG = LoggerFactory.getLogger(FileCertificateProvider.class);

    public FileCertificateProvider(String certificateFilePath, String privateKeyFilePath) {
        this.certificateFilePath = Objects.requireNonNull(certificateFilePath);
        this.privateKeyFilePath = Objects.requireNonNull(privateKeyFilePath);
    }

    @Override
    public Certificate getCertificate() {
        try {
            Path certFilePath = new File(this.certificateFilePath).toPath();
            Path pkFilePath = new File(this.privateKeyFilePath).toPath();
            byte[] certFileBytes = Files.readAllBytes(certFilePath);
            byte[] pkFileBytes = Files.readAllBytes(pkFilePath);
            String certAsString = new String(certFileBytes);
            String privateKeyAsString = new String(pkFileBytes);
            return new Certificate(certAsString, privateKeyAsString);
        }
        catch (Exception ex) {
            LOG.error("Error encountered while reading the certificate.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

