/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.model.plugin.FailedToUpdatePluginConfigValueException;
import org.opensearch.dataprepper.plugins.aws.AwsSecretManagerConfiguration;
import org.opensearch.dataprepper.plugins.aws.AwsSecretPluginConfig;
import org.opensearch.dataprepper.plugins.aws.SecretValueDecoder;
import org.opensearch.dataprepper.plugins.aws.SecretsSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse;

public class AwsSecretsSupplier
implements SecretsSupplier {
    static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};
    private static final Logger LOG = LoggerFactory.getLogger(AwsSecretsSupplier.class);
    private final SecretValueDecoder secretValueDecoder;
    private final ObjectMapper objectMapper;
    private final Map<String, AwsSecretManagerConfiguration> awsSecretManagerConfigurationMap;
    private final Map<String, SecretsManagerClient> secretsManagerClientMap;
    private final ConcurrentMap<String, Object> secretIdToValue;

    public AwsSecretsSupplier(SecretValueDecoder secretValueDecoder, AwsSecretPluginConfig awsSecretPluginConfig, ObjectMapper objectMapper, AwsCredentialsSupplier awsCredentialsSupplier) {
        this.secretValueDecoder = secretValueDecoder;
        this.objectMapper = objectMapper;
        this.awsSecretManagerConfigurationMap = awsSecretPluginConfig.getAwsSecretManagerConfigurationMap();
        this.secretsManagerClientMap = this.toSecretsManagerClientMap(awsSecretPluginConfig, awsCredentialsSupplier);
        this.secretIdToValue = this.toSecretMap(this.awsSecretManagerConfigurationMap);
    }

    private ConcurrentMap<String, Object> toSecretMap(Map<String, AwsSecretManagerConfiguration> awsSecretManagerConfigurationMap) {
        return this.secretsManagerClientMap.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, entry -> {
            String secretConfigurationId = (String)entry.getKey();
            AwsSecretManagerConfiguration awsSecretManagerConfiguration = (AwsSecretManagerConfiguration)awsSecretManagerConfigurationMap.get(secretConfigurationId);
            SecretsManagerClient secretsManagerClient = (SecretsManagerClient)entry.getValue();
            return this.retrieveSecretsFromSecretManager(awsSecretManagerConfiguration, secretsManagerClient);
        }));
    }

    private Map<String, SecretsManagerClient> toSecretsManagerClientMap(AwsSecretPluginConfig awsSecretPluginConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        return awsSecretPluginConfig.getAwsSecretManagerConfigurationMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            AwsSecretManagerConfiguration awsSecretManagerConfiguration = (AwsSecretManagerConfiguration)entry.getValue();
            return awsSecretManagerConfiguration.createSecretManagerClient(awsCredentialsSupplier);
        }));
    }

    @Override
    public Object retrieveValue(String secretId, String key) {
        if (!this.secretIdToValue.containsKey(secretId)) {
            throw new IllegalArgumentException(String.format("Unable to find secretId: %s", secretId));
        }
        Object keyValuePairs = this.secretIdToValue.get(secretId);
        if (!(keyValuePairs instanceof Map)) {
            throw new IllegalArgumentException(String.format("The value under secretId: %s is not a valid json.", secretId));
        }
        Map keyValueMap = (Map)keyValuePairs;
        if (!keyValueMap.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Unable to find the value of key: %s under secretId: %s", key, secretId));
        }
        return keyValueMap.get(key);
    }

    @Override
    public Object retrieveValue(String secretId) {
        if (!this.secretIdToValue.containsKey(secretId)) {
            throw new IllegalArgumentException(String.format("Unable to find secretId: %s", secretId));
        }
        try {
            Object secretValue = this.secretIdToValue.get(secretId);
            return secretValue instanceof Map ? this.objectMapper.writeValueAsString(secretValue) : secretValue;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Unable to read the value under secretId: %s as string.", secretId));
        }
    }

    @Override
    public void refresh(String secretConfigId) {
        LOG.info("Retrieving latest secrets in aws:secrets:{}.", (Object)secretConfigId);
        this.secretIdToValue.compute(secretConfigId, (key, oldValue) -> {
            AwsSecretManagerConfiguration awsSecretManagerConfiguration = this.awsSecretManagerConfigurationMap.get(key);
            SecretsManagerClient secretsManagerClient = this.secretsManagerClientMap.get(key);
            return this.retrieveSecretsFromSecretManager(awsSecretManagerConfiguration, secretsManagerClient);
        });
        LOG.info("Finished retrieving latest secret in aws:secrets:{}.", (Object)secretConfigId);
    }

    private Object retrieveSecretsFromSecretManager(AwsSecretManagerConfiguration awsSecretManagerConfiguration, SecretsManagerClient secretsManagerClient) {
        GetSecretValueResponse getSecretValueResponse;
        GetSecretValueRequest getSecretValueRequest = awsSecretManagerConfiguration.createGetSecretValueRequest();
        try {
            getSecretValueResponse = secretsManagerClient.getSecretValue(getSecretValueRequest);
        }
        catch (AwsServiceException e) {
            LOG.error("Unable to retrieve secret {}: {}", (Object)getSecretValueRequest.secretId(), (Object)e.getMessage());
            throw new RuntimeException(String.format("Unable to retrieve secret: %s", awsSecretManagerConfiguration.getAwsSecretId()), e);
        }
        catch (Exception ex) {
            LOG.error("Unable to retrieve secret {} due to unexpected error", (Object)getSecretValueRequest.secretId(), (Object)ex);
            throw new RuntimeException(String.format("Unable to retrieve secret: %s", awsSecretManagerConfiguration.getAwsSecretId()), ex);
        }
        try {
            return this.objectMapper.readValue(this.secretValueDecoder.decode(getSecretValueResponse), MAP_TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            return this.secretValueDecoder.decode(getSecretValueResponse);
        }
    }

    @Override
    public String updateValue(String secretId, Object newValue) {
        return this.updateValue(secretId, null, newValue);
    }

    @Override
    public String updateValue(String secretId, String keyToUpdate, Object newValue) {
        Object currentSecretStore = this.secretIdToValue.get(secretId);
        if (currentSecretStore instanceof Map) {
            if (keyToUpdate == null) {
                throw new IllegalArgumentException(String.format("Key to update cannot be null for a key value based secret. secretId: %s", secretId));
            }
            Map keyValuePairs = (Map)currentSecretStore;
            keyValuePairs.put(keyToUpdate, newValue);
        } else {
            this.secretIdToValue.put(secretId, newValue);
        }
        String secretKeyValueMapAsString = (String)this.retrieveValue(secretId);
        AwsSecretManagerConfiguration awsSecretManagerConfiguration = this.awsSecretManagerConfigurationMap.get(secretId);
        PutSecretValueRequest putSecretValueRequest = awsSecretManagerConfiguration.putSecretValueRequest(secretKeyValueMapAsString);
        SecretsManagerClient secretsManagerClient = this.secretsManagerClientMap.get(secretId);
        try {
            PutSecretValueResponse putSecretValueResponse = secretsManagerClient.putSecretValue(putSecretValueRequest);
            LOG.info("Updated key: {} in the secret {}. New version of the store is {}", new Object[]{keyToUpdate, secretId, putSecretValueResponse.versionId()});
            return putSecretValueResponse.versionId();
        }
        catch (Exception e) {
            throw new FailedToUpdatePluginConfigValueException(String.format("Failed to update the secret: %s to put a new value for the key: %s", awsSecretManagerConfiguration.getAwsSecretId(), keyToUpdate), (Throwable)e);
        }
    }
}

