/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.log;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.log.OpenTelemetryLog;

public class JacksonOtelLog
extends JacksonEvent
implements OpenTelemetryLog {
    protected static final String OBSERVED_TIME_KEY = "observedTime";
    protected static final String TIME_KEY = "time";
    protected static final String SERVICE_NAME_KEY = "serviceName";
    protected static final String ATTRIBUTES_KEY = "attributes";
    protected static final String SCHEMA_URL_KEY = "schemaUrl";
    protected static final String FLAGS_KEY = "flags";
    protected static final String BODY_KEY = "body";
    protected static final String SPAN_ID_KEY = "spanId";
    protected static final String TRACE_ID_KEY = "traceId";
    protected static final String SEVERITY_NUMBER_KEY = "severityNumber";
    protected static final String DROPPED_ATTRIBUTES_COUNT_KEY = "droppedAttributesCount";

    protected JacksonOtelLog(Builder builder) {
        super(builder);
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals("LOG"), (Object)"eventType must be of type Log");
    }

    @Override
    public String getServiceName() {
        return this.get(SERVICE_NAME_KEY, String.class);
    }

    @Override
    public String getObservedTime() {
        return this.get(OBSERVED_TIME_KEY, String.class);
    }

    @Override
    public String getTime() {
        return this.get(TIME_KEY, String.class);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.get(ATTRIBUTES_KEY, Map.class);
    }

    @Override
    public String getSchemaUrl() {
        return this.get(SCHEMA_URL_KEY, String.class);
    }

    @Override
    public Integer getFlags() {
        return this.get(FLAGS_KEY, Integer.class);
    }

    @Override
    public String getSpanId() {
        return this.get(SPAN_ID_KEY, String.class);
    }

    @Override
    public String getTraceId() {
        return this.get(TRACE_ID_KEY, String.class);
    }

    @Override
    public Integer getSeverityNumber() {
        return this.get(SEVERITY_NUMBER_KEY, Integer.class);
    }

    @Override
    public Integer getDroppedAttributesCount() {
        return this.get(DROPPED_ATTRIBUTES_COUNT_KEY, Integer.class);
    }

    @Override
    public Object getBody() {
        return this.get(BODY_KEY, Object.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toJsonString() {
        JsonNode anyAttributes = this.getJsonNode().get(ATTRIBUTES_KEY);
        if (anyAttributes instanceof ObjectNode) {
            ObjectNode flattenedJsonNode = (ObjectNode)this.getJsonNode().deepCopy();
            flattenedJsonNode.remove(ATTRIBUTES_KEY);
            Iterator it = ((ObjectNode)anyAttributes).fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String field = (String)entry.getKey();
                if (flattenedJsonNode.has(field)) continue;
                flattenedJsonNode.set(field, (JsonNode)entry.getValue());
            }
            return flattenedJsonNode.toString();
        }
        return super.toJsonString();
    }

    public static class Builder
    extends JacksonEvent.Builder<Builder> {
        protected final Map<String, Object> data = new HashMap<String, Object>();

        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.data.put(JacksonOtelLog.ATTRIBUTES_KEY, attributes);
            return this.getThis();
        }

        public Builder withObservedTime(String observedTime) {
            this.data.put(JacksonOtelLog.OBSERVED_TIME_KEY, observedTime);
            return this.getThis();
        }

        public Builder withTime(String time) {
            this.data.put(JacksonOtelLog.TIME_KEY, time);
            return this.getThis();
        }

        public Builder withServiceName(String serviceName) {
            this.data.put(JacksonOtelLog.SERVICE_NAME_KEY, serviceName);
            return this.getThis();
        }

        public Builder withSchemaUrl(String schemaUrl) {
            this.data.put(JacksonOtelLog.SCHEMA_URL_KEY, schemaUrl);
            return this.getThis();
        }

        public Builder withFlags(Integer flags) {
            this.data.put(JacksonOtelLog.FLAGS_KEY, flags);
            return this.getThis();
        }

        public Builder withBody(Object body) {
            this.data.put(JacksonOtelLog.BODY_KEY, body);
            return this.getThis();
        }

        public Builder withSpanId(String spanId) {
            this.data.put(JacksonOtelLog.SPAN_ID_KEY, spanId);
            return this.getThis();
        }

        public Builder withTraceId(String traceId) {
            this.data.put(JacksonOtelLog.TRACE_ID_KEY, traceId);
            return this.getThis();
        }

        public Builder withSeverityNumber(Integer severityNumber) {
            this.data.put(JacksonOtelLog.SEVERITY_NUMBER_KEY, severityNumber);
            return this.getThis();
        }

        public Builder withDroppedAttributesCount(Integer droppedAttributesCount) {
            this.data.put(JacksonOtelLog.DROPPED_ATTRIBUTES_COUNT_KEY, droppedAttributesCount);
            return this.getThis();
        }

        @Override
        public JacksonOtelLog build() {
            this.withEventType(EventType.LOG.toString());
            this.withData(this.data);
            this.checkAndSetDefaultValues();
            return new JacksonOtelLog(this);
        }

        private void checkAndSetDefaultValues() {
            this.data.computeIfAbsent(JacksonOtelLog.ATTRIBUTES_KEY, k -> new HashMap());
        }
    }
}

