/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@JsonSerialize(using=PluginModelSerializer.class)
@JsonDeserialize(using=PluginModelDeserializer.class)
public class PluginModel {
    private static final ObjectMapper SERIALIZER_OBJECT_MAPPER = new ObjectMapper();
    private final String pluginName;
    private final InternalJsonModel innerModel;

    public PluginModel(String pluginName, Map<String, Object> pluginSettings) {
        this(pluginName, new InternalJsonModel(pluginSettings));
    }

    protected PluginModel(String pluginName, InternalJsonModel innerModel) {
        this.pluginName = pluginName;
        this.innerModel = Objects.requireNonNull(innerModel);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Map<String, Object> getPluginSettings() {
        return this.innerModel.pluginSettings;
    }

    <M extends InternalJsonModel> M getInternalJsonModel() {
        return (M)this.innerModel;
    }

    static abstract class AbstractPluginModelDeserializer<T extends PluginModel, M extends InternalJsonModel>
    extends StdDeserializer<PluginModel> {
        private final Class<M> innerModelClass;
        private final BiFunction<String, M, T> constructorFunction;
        private final Supplier<M> emptyInnerModelConstructor;

        protected AbstractPluginModelDeserializer(Class<T> valueClass, Class<M> innerModelClass, BiFunction<String, M, T> constructorFunction, Supplier<M> emptyInnerModelConstructor) {
            super(valueClass);
            this.innerModelClass = innerModelClass;
            this.constructorFunction = constructorFunction;
            this.emptyInnerModelConstructor = emptyInnerModelConstructor;
        }

        public PluginModel deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JacksonException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Iterator fields = node.fields();
            Map.Entry onlyField = (Map.Entry)fields.next();
            String pluginName = (String)onlyField.getKey();
            JsonNode value = (JsonNode)onlyField.getValue();
            InternalJsonModel innerModel = (InternalJsonModel)SERIALIZER_OBJECT_MAPPER.convertValue((Object)value, this.innerModelClass);
            if (innerModel == null) {
                innerModel = (InternalJsonModel)this.emptyInnerModelConstructor.get();
            }
            return (PluginModel)this.constructorFunction.apply(pluginName, innerModel);
        }
    }

    static final class PluginModelDeserializer
    extends AbstractPluginModelDeserializer<PluginModel, InternalJsonModel> {
        public PluginModelDeserializer() {
            super(PluginModel.class, InternalJsonModel.class, PluginModel::new, InternalJsonModel::new);
        }
    }

    static class PluginModelSerializer
    extends StdSerializer<PluginModel> {
        public PluginModelSerializer() {
            this(null);
        }

        public PluginModelSerializer(Class<PluginModel> valueClass) {
            super(valueClass);
        }

        public void serialize(PluginModel value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Map serializedInner = (Map)SERIALIZER_OBJECT_MAPPER.convertValue((Object)value.innerModel, Map.class);
            if (serializedInner != null && serializedInner.isEmpty()) {
                serializedInner = null;
            }
            gen.writeObjectField(value.getPluginName(), (Object)serializedInner);
            gen.writeEndObject();
        }
    }

    static class InternalJsonModel {
        @JsonAnySetter
        @JsonAnyGetter
        private final Map<String, Object> pluginSettings;

        @JsonCreator
        InternalJsonModel() {
            this(new HashMap<String, Object>());
        }

        InternalJsonModel(Map<String, Object> pluginSettings) {
            this.pluginSettings = pluginSettings;
        }
    }
}

