/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.codec;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.log.JacksonLog;
import org.opensearch.dataprepper.model.record.Record;

public class JsonObjectDecoder
implements ByteDecoder {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JsonFactory jsonFactory = new JsonFactory();

    @Override
    public void parse(InputStream inputStream, Instant timeReceived, Consumer<Record<Event>> eventConsumer) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(eventConsumer);
        JsonParser jsonParser = this.jsonFactory.createParser(inputStream);
        while (!jsonParser.isClosed() && jsonParser.nextToken() != JsonToken.END_OBJECT) {
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            Map innerJson = (Map)this.objectMapper.readValue(jsonParser, Map.class);
            Record<Event> record = this.createRecord(innerJson, timeReceived);
            eventConsumer.accept(record);
        }
    }

    private Record<Event> createRecord(Map<String, Object> json, Instant timeReceived) {
        JacksonLog.Builder logBuilder = (JacksonLog.Builder)JacksonLog.builder().withData(json).getThis();
        if (timeReceived != null) {
            logBuilder.withTimeReceived(timeReceived);
        }
        JacksonLog event = logBuilder.build();
        return new Record<Event>(event);
    }
}

