/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.configuration;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

@JsonSerialize(using=PluginModelSerializer.class)
@JsonDeserialize(using=PluginModelDeserializer.class)
public class PluginModel {
    private final String pluginName;
    private final Map<String, Object> pluginSettings;

    public PluginModel(String pluginName, Map<String, Object> pluginSettings) {
        this.pluginName = pluginName;
        this.pluginSettings = pluginSettings;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Map<String, Object> getPluginSettings() {
        return this.pluginSettings;
    }

    static class PluginModelDeserializer
    extends StdDeserializer<PluginModel> {
        static final ObjectMapper mapper = new ObjectMapper();

        public PluginModelDeserializer() {
            this(null);
        }

        public PluginModelDeserializer(Class<PluginModel> valueClass) {
            super(valueClass);
        }

        public PluginModel deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JacksonException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Iterator fields = node.fields();
            Map.Entry onlyField = (Map.Entry)fields.next();
            String pluginName = (String)onlyField.getKey();
            JsonNode value = (JsonNode)onlyField.getValue();
            Map settingsMap = (Map)mapper.convertValue((Object)value, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return new PluginModel(pluginName, settingsMap);
        }
    }

    static class PluginModelSerializer
    extends StdSerializer<PluginModel> {
        public PluginModelSerializer() {
            this(null);
        }

        public PluginModelSerializer(Class<PluginModel> valueClass) {
            super(valueClass);
        }

        public void serialize(PluginModel value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField(value.getPluginName(), value.getPluginSettings());
            gen.writeEndObject();
        }
    }
}

