/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.io.IOException;
import org.opensearch.client.ApiClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.transport.Transport;
import org.opensearch.data.client.osc.OpenSearchExceptionTranslator;
import org.opensearch.data.client.osc.RequestConverter;
import org.opensearch.data.client.osc.ResponseConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;

public abstract class ChildTemplate<T extends Transport, CLIENT extends ApiClient<T, CLIENT>> {
    protected final CLIENT client;
    protected final RequestConverter requestConverter;
    protected final ResponseConverter responseConverter;
    protected final OpenSearchExceptionTranslator exceptionTranslator;

    public ChildTemplate(CLIENT client, ElasticsearchConverter elasticsearchConverter) {
        this.client = client;
        JsonpMapper jsonpMapper = client._transport().jsonpMapper();
        this.requestConverter = new RequestConverter(elasticsearchConverter, jsonpMapper);
        this.responseConverter = new ResponseConverter(jsonpMapper);
        this.exceptionTranslator = new OpenSearchExceptionTranslator(jsonpMapper);
    }

    public <RESULT> RESULT execute(ClientCallback<CLIENT, RESULT> callback) {
        Assert.notNull(callback, (String)"callback must not be null");
        try {
            return callback.doWithClient(this.client);
        }
        catch (IOException | RuntimeException e) {
            throw this.exceptionTranslator.translateException(e);
        }
    }

    @FunctionalInterface
    public static interface ClientCallback<CLIENT, RESULT> {
        public RESULT doWithClient(CLIENT var1) throws IOException;
    }
}

