/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.opensearch.client.ApiClient;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.ClearScrollResponse;
import org.opensearch.client.opensearch.core.CountRequest;
import org.opensearch.client.opensearch.core.CountResponse;
import org.opensearch.client.opensearch.core.CreatePitRequest;
import org.opensearch.client.opensearch.core.CreatePitResponse;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.DeletePitRequest;
import org.opensearch.client.opensearch.core.DeletePitResponse;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.DeleteScriptRequest;
import org.opensearch.client.opensearch.core.DeleteScriptResponse;
import org.opensearch.client.opensearch.core.ExistsRequest;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.GetScriptRequest;
import org.opensearch.client.opensearch.core.GetScriptResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.InfoRequest;
import org.opensearch.client.opensearch.core.InfoResponse;
import org.opensearch.client.opensearch.core.MgetRequest;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.PingRequest;
import org.opensearch.client.opensearch.core.PutScriptRequest;
import org.opensearch.client.opensearch.core.PutScriptResponse;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.ReindexResponse;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.SearchTemplateRequest;
import org.opensearch.client.opensearch.core.SearchTemplateResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.Transport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.endpoints.EndpointWithResponseMapperAttr;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.data.client.osc.ReactiveOpenSearchClusterClient;
import org.opensearch.data.client.osc.ReactiveOpenSearchIndicesClient;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveOpenSearchClient
extends ApiClient<OpenSearchTransport, ReactiveOpenSearchClient>
implements AutoCloseable {
    public ReactiveOpenSearchClient(OpenSearchTransport transport) {
        super((Transport)transport, null);
    }

    public ReactiveOpenSearchClient(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        super((Transport)transport, transportOptions);
    }

    public ReactiveOpenSearchClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ReactiveOpenSearchClient((OpenSearchTransport)this.transport, transportOptions);
    }

    @Override
    public void close() throws IOException {
    }

    public ReactiveOpenSearchClusterClient cluster() {
        return new ReactiveOpenSearchClusterClient((OpenSearchTransport)this.transport, this.transportOptions);
    }

    public ReactiveOpenSearchIndicesClient indices() {
        return new ReactiveOpenSearchIndicesClient((OpenSearchTransport)this.transport, this.transportOptions);
    }

    public Mono<InfoResponse> info() {
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)InfoRequest.builder().build(), InfoRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<BooleanResponse> ping() {
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)PingRequest.builder().build(), PingRequest._ENDPOINT, this.transportOptions));
    }

    public <T> Mono<IndexResponse> index(IndexRequest<T> request) {
        Assert.notNull(request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync(request, IndexRequest._ENDPOINT, this.transportOptions));
    }

    public <T> Mono<IndexResponse> index(Function<IndexRequest.Builder<T>, ObjectBuilder<IndexRequest<T>>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.index((IndexRequest)fn.apply(new IndexRequest.Builder()).build());
    }

    public Mono<BulkResponse> bulk(BulkRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, BulkRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<BulkResponse> bulk(Function<BulkRequest.Builder, ObjectBuilder<BulkRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.bulk((BulkRequest)fn.apply(new BulkRequest.Builder()).build());
    }

    public <T> Mono<GetResponse<T>> get(GetRequest request, Class<T> tClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        SimpleEndpoint endpoint = GetRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)endpoint, "org.opensearch.client:Deserializer:_global.get.TDocument", (Object)this.getDeserializer(tClass));
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, (Endpoint)endpoint, this.transportOptions));
    }

    public Mono<BooleanResponse> exists(ExistsRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, ExistsRequest._ENDPOINT, this.transportOptions));
    }

    public <T, P> Mono<UpdateResponse<T>> update(UpdateRequest<T, P> request, Class<T> clazz) {
        Assert.notNull(request, (String)"request must not be null");
        EndpointWithResponseMapperAttr endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)UpdateRequest._ENDPOINT, "org.opensearch.client:Deserializer:_global.update.TDocument", (Object)this.getDeserializer(clazz));
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync(request, (Endpoint)endpoint, this.transportOptions));
    }

    public <T, P> Mono<UpdateResponse<T>> update(Function<UpdateRequest.Builder<T, P>, ObjectBuilder<UpdateRequest<T, P>>> fn, Class<T> clazz) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.update((UpdateRequest)fn.apply(new UpdateRequest.Builder()).build(), clazz);
    }

    public <T> Mono<GetResponse<T>> get(Function<GetRequest.Builder, ObjectBuilder<GetRequest>> fn, Class<T> tClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.get((GetRequest)fn.apply(new GetRequest.Builder()).build(), tClass);
    }

    public <T> Mono<MgetResponse<T>> mget(MgetRequest request, Class<T> clazz) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        SimpleEndpoint endpoint = MgetRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)endpoint, "org.opensearch.client:Deserializer:_global.mget.TDocument", (Object)this.getDeserializer(clazz));
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, (Endpoint)endpoint, this.transportOptions));
    }

    public <T> Mono<MgetResponse<T>> mget(Function<MgetRequest.Builder, ObjectBuilder<MgetRequest>> fn, Class<T> clazz) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.mget((MgetRequest)fn.apply(new MgetRequest.Builder()).build(), clazz);
    }

    public Mono<ReindexResponse> reindex(ReindexRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, ReindexRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<ReindexResponse> reindex(Function<ReindexRequest.Builder, ObjectBuilder<ReindexRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.reindex((ReindexRequest)fn.apply(new ReindexRequest.Builder()).build());
    }

    public Mono<DeleteResponse> delete(DeleteRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, DeleteRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeleteResponse> delete(Function<DeleteRequest.Builder, ObjectBuilder<DeleteRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.delete((DeleteRequest)fn.apply(new DeleteRequest.Builder()).build());
    }

    public Mono<DeleteByQueryResponse> deleteByQuery(DeleteByQueryRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, DeleteByQueryRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeleteByQueryResponse> deleteByQuery(Function<DeleteByQueryRequest.Builder, ObjectBuilder<DeleteByQueryRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.deleteByQuery((DeleteByQueryRequest)fn.apply(new DeleteByQueryRequest.Builder()).build());
    }

    public Mono<CountResponse> count(CountRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, CountRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<CountResponse> count(Function<CountRequest.Builder, ObjectBuilder<CountRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.count((CountRequest)fn.apply(new CountRequest.Builder()).build());
    }

    public <T> Mono<SearchResponse<T>> search(SearchRequest request, Class<T> tDocumentClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, SearchRequest.createSearchEndpoint((JsonpDeserializer)this.getDeserializer(tDocumentClass)), this.transportOptions));
    }

    public <T> Mono<SearchResponse<T>> search(Function<SearchRequest.Builder, ObjectBuilder<SearchRequest>> fn, Class<T> tDocumentClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return this.search((SearchRequest)fn.apply(new SearchRequest.Builder()).build(), tDocumentClass);
    }

    public <T> Mono<SearchTemplateResponse<T>> searchTemplate(SearchTemplateRequest request, Class<T> tDocumentClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, SearchTemplateRequest.createSearchTemplateEndpoint((JsonpDeserializer)this.getDeserializer(tDocumentClass)), this.transportOptions));
    }

    public <T> Mono<SearchTemplateResponse<T>> searchTemplate(Function<SearchTemplateRequest.Builder, ObjectBuilder<SearchTemplateRequest>> fn, Class<T> tDocumentClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.searchTemplate((SearchTemplateRequest)fn.apply(new SearchTemplateRequest.Builder()).build(), tDocumentClass);
    }

    public <T> Mono<ScrollResponse<T>> scroll(ScrollRequest request, Class<T> tDocumentClass) {
        Assert.notNull((Object)request, (String)"request must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        SimpleEndpoint endpoint = ScrollRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr((JsonEndpoint)endpoint, "org.opensearch.client:Deserializer:_global.scroll.TDocument", (Object)this.getDeserializer(tDocumentClass));
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, (Endpoint)endpoint, this.transportOptions));
    }

    public <T> Mono<ScrollResponse<T>> scroll(Function<ScrollRequest.Builder, ObjectBuilder<ScrollRequest>> fn, Class<T> tDocumentClass) {
        Assert.notNull(fn, (String)"fn must not be null");
        Assert.notNull(tDocumentClass, (String)"tDocumentClass must not be null");
        return this.scroll((ScrollRequest)fn.apply(new ScrollRequest.Builder()).build(), tDocumentClass);
    }

    public Mono<ClearScrollResponse> clearScroll(ClearScrollRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, ClearScrollRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<ClearScrollResponse> clearScroll(Function<ClearScrollRequest.Builder, ObjectBuilder<ClearScrollRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.clearScroll((ClearScrollRequest)fn.apply(new ClearScrollRequest.Builder()).build());
    }

    public Mono<PutScriptResponse> putScript(PutScriptRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, PutScriptRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<PutScriptResponse> putScript(Function<PutScriptRequest.Builder, ObjectBuilder<PutScriptRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.putScript((PutScriptRequest)fn.apply(new PutScriptRequest.Builder()).build());
    }

    public Mono<GetScriptResponse> getScript(GetScriptRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, GetScriptRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<GetScriptResponse> getScript(Function<GetScriptRequest.Builder, ObjectBuilder<GetScriptRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.getScript((GetScriptRequest)fn.apply(new GetScriptRequest.Builder()).build());
    }

    public Mono<DeleteScriptResponse> deleteScript(DeleteScriptRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, DeleteScriptRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeleteScriptResponse> deleteScript(Function<DeleteScriptRequest.Builder, ObjectBuilder<DeleteScriptRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.deleteScript((DeleteScriptRequest)fn.apply(new DeleteScriptRequest.Builder()).build());
    }

    public Mono<CreatePitResponse> openPointInTime(CreatePitRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, CreatePitRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeletePitResponse> closePointInTime(DeletePitRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return Mono.fromFuture((CompletableFuture)((OpenSearchTransport)this.transport).performRequestAsync((Object)request, DeletePitRequest._ENDPOINT, this.transportOptions));
    }

    public Mono<DeletePitResponse> closePointInTime(Function<DeletePitRequest.Builder, ObjectBuilder<DeletePitRequest>> fn) {
        Assert.notNull(fn, (String)"fn must not be null");
        return this.closePointInTime((DeletePitRequest)fn.apply(new DeletePitRequest.Builder()).build());
    }
}

