/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.Version;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.DeletePitInfo;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.data.client.orhlc.DocumentAdapters;
import org.opensearch.data.client.orhlc.NativeSearchQueryBuilder;
import org.opensearch.data.client.orhlc.OpenSearchClusterOperations;
import org.opensearch.data.client.orhlc.OpenSearchExceptionTranslator;
import org.opensearch.data.client.orhlc.RequestFactory;
import org.opensearch.data.client.orhlc.ResponseConverter;
import org.opensearch.data.client.orhlc.RestIndexTemplate;
import org.opensearch.data.client.orhlc.SearchDocumentResponseBuilder;
import org.opensearch.data.client.orhlc.SearchHitsUtil;
import org.opensearch.data.core.OpenSearchOperations;
import org.opensearch.index.query.MoreLikeThisQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.suggest.SuggestBuilder;
import org.springframework.dao.DataAccessException;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.BulkFailureException;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.cluster.ClusterOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SqlQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.data.elasticsearch.core.sql.SqlResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenSearchRestTemplate
extends AbstractElasticsearchTemplate
implements OpenSearchOperations {
    private static final Log LOGGER = LogFactory.getLog(OpenSearchRestTemplate.class);
    private final RestHighLevelClient client;
    private final OpenSearchExceptionTranslator exceptionTranslator = new OpenSearchExceptionTranslator();
    protected RequestFactory requestFactory;

    public OpenSearchRestTemplate(RestHighLevelClient client) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        this.client = client;
        this.requestFactory = new RequestFactory(this.elasticsearchConverter);
    }

    public OpenSearchRestTemplate(RestHighLevelClient client, ElasticsearchConverter opensearchConverter) {
        super(opensearchConverter);
        Assert.notNull((Object)client, (String)"Client must not be null!");
        this.client = client;
        this.requestFactory = new RequestFactory(this.elasticsearchConverter);
    }

    protected AbstractElasticsearchTemplate doCopy() {
        OpenSearchRestTemplate copy = new OpenSearchRestTemplate(this.client, this.elasticsearchConverter);
        copy.requestFactory = this.requestFactory;
        return copy;
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public IndexOperations indexOps(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        return new RestIndexTemplate(this, clazz);
    }

    public IndexOperations indexOps(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        return new RestIndexTemplate(this, index);
    }

    public ClusterOperations cluster() {
        return OpenSearchClusterOperations.forTemplate(this);
    }

    public String doIndex(IndexQuery query, IndexCoordinates index) {
        IndexRequest request = this.prepareWriteRequest(this.requestFactory.indexRequest(query, index));
        IndexResponse indexResponse = this.execute(client -> client.index(request, RequestOptions.DEFAULT));
        Object queryObject = query.getObject();
        if (queryObject != null) {
            query.setObject(this.entityOperations.updateIndexedObject(queryObject, new IndexedObjectInformation(indexResponse.getId(), indexResponse.getIndex(), Long.valueOf(indexResponse.getSeqNo()), Long.valueOf(indexResponse.getPrimaryTerm()), Long.valueOf(indexResponse.getVersion())), this.elasticsearchConverter, this.routingResolver));
        }
        return indexResponse.getId();
    }

    @Nullable
    public <T> T get(String id, Class<T> clazz, IndexCoordinates index) {
        GetRequest request = this.requestFactory.getRequest(id, this.routingResolver.getRouting(), index);
        GetResponse response = this.execute(client -> client.get(request, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadDocumentCallback callback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        return (T)callback.doWith(DocumentAdapters.from(response));
    }

    public <T> List<MultiGetItem<T>> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        MultiGetRequest request = this.requestFactory.multiGetRequest(query, clazz, index);
        MultiGetResponse result = this.execute(client -> client.mget(request, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadDocumentCallback callback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        return DocumentAdapters.from(result).stream().map(arg_0 -> OpenSearchRestTemplate.lambda$multiGet$3((AbstractElasticsearchTemplate.DocumentCallback)callback, arg_0)).collect(Collectors.toList());
    }

    protected boolean doExists(String id, IndexCoordinates index) {
        GetRequest request = this.requestFactory.getRequest(id, this.routingResolver.getRouting(), index);
        request.fetchSourceContext(FetchSourceContext.DO_NOT_FETCH_SOURCE);
        return this.execute(client -> client.get(request, RequestOptions.DEFAULT).isExists());
    }

    public void bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        this.doBulkOperation(queries, bulkOptions, index);
    }

    protected String doDelete(String id, @Nullable String routing, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        DeleteRequest request = this.prepareWriteRequest(this.requestFactory.deleteRequest(this.elasticsearchConverter.convertId((Object)id), routing, index));
        return this.execute(client -> client.delete(request, RequestOptions.DEFAULT).getId());
    }

    public ByQueryResponse delete(DeleteQuery query, Class<?> clazz) {
        return this.delete(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    public ByQueryResponse delete(DeleteQuery query, Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        DeleteByQueryRequest deleteByQueryRequest = this.requestFactory.documentDeleteByQueryRequest(query, this.routingResolver.getRouting(), clazz, index, this.getRefreshPolicy());
        return ResponseConverter.byQueryResponseOf(this.execute(client -> client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT)));
    }

    public UpdateResponse update(UpdateQuery query, IndexCoordinates index) {
        UpdateRequest request = this.requestFactory.updateRequest(query, index);
        if (query.getRefreshPolicy() == null && this.getRefreshPolicy() != null) {
            request.setRefreshPolicy(RequestFactory.toOpenSearchRefreshPolicy(this.getRefreshPolicy()));
        }
        if (query.getRouting() == null && this.routingResolver.getRouting() != null) {
            request.routing(this.routingResolver.getRouting());
        }
        UpdateResponse.Result result = UpdateResponse.Result.valueOf((String)this.execute(client -> client.update(request, RequestOptions.DEFAULT)).getResult().name());
        return new UpdateResponse(result);
    }

    public ByQueryResponse updateByQuery(UpdateQuery query, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        UpdateByQueryRequest updateByQueryRequest = this.requestFactory.updateByQueryRequest(query, index);
        if (query.getRefreshPolicy() == null && this.getRefreshPolicy() != null) {
            updateByQueryRequest.setRefresh(this.getRefreshPolicy() == RefreshPolicy.IMMEDIATE);
        }
        if (query.getRouting() == null && this.routingResolver.getRouting() != null) {
            updateByQueryRequest.setRouting(this.routingResolver.getRouting());
        }
        BulkByScrollResponse bulkByScrollResponse = this.execute(client -> client.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT));
        return ResponseConverter.byQueryResponseOf(bulkByScrollResponse);
    }

    public ReindexResponse reindex(ReindexRequest reindexRequest) {
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        org.opensearch.index.reindex.ReindexRequest reindexRequestES = this.requestFactory.reindexRequest(reindexRequest);
        BulkByScrollResponse bulkByScrollResponse = this.execute(client -> client.reindex(reindexRequestES, RequestOptions.DEFAULT));
        return ResponseConverter.reindexResponseOf(bulkByScrollResponse);
    }

    public String submitReindex(ReindexRequest reindexRequest) {
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        org.opensearch.index.reindex.ReindexRequest reindexRequestES = this.requestFactory.reindexRequest(reindexRequest);
        return this.execute(client -> client.submitReindexTask(reindexRequestES, RequestOptions.DEFAULT).getTask());
    }

    public List<IndexedObjectInformation> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = this.prepareWriteRequest(this.requestFactory.bulkRequest(queries, bulkOptions, index));
        List<IndexedObjectInformation> indexedObjectInformationList = this.checkForBulkOperationFailure(this.execute(client -> client.bulk(bulkRequest, RequestOptions.DEFAULT)));
        this.updateIndexedObjectsWithQueries(queries, indexedObjectInformationList);
        return indexedObjectInformationList;
    }

    protected <R extends WriteRequest<R>> R prepareWriteRequest(R request) {
        if (this.refreshPolicy == null) {
            return request;
        }
        return (R)request.setRefreshPolicy(RequestFactory.toOpenSearchRefreshPolicy(this.refreshPolicy));
    }

    protected List<IndexedObjectInformation> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            HashMap<String, BulkFailureException.FailureDetails> failedDocuments = new HashMap<String, BulkFailureException.FailureDetails>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), new BulkFailureException.FailureDetails(Integer.valueOf(item.status().getStatus()), item.getFailureMessage()));
            }
            throw new BulkFailureException("Bulk operation has failures. Use BulkFailureException.getFailedDocuments() for detailed messages [" + String.valueOf(failedDocuments) + "]", failedDocuments);
        }
        return Stream.of(bulkResponse.getItems()).map(bulkItemResponse -> {
            DocWriteResponse response = bulkItemResponse.getResponse();
            if (response != null) {
                return new IndexedObjectInformation(response.getId(), response.getIndex(), Long.valueOf(response.getSeqNo()), Long.valueOf(response.getPrimaryTerm()), Long.valueOf(response.getVersion()));
            }
            return new IndexedObjectInformation(bulkItemResponse.getId(), bulkItemResponse.getIndex(), null, null, null);
        }).collect(Collectors.toList());
    }

    public long count(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Boolean trackTotalHits = query.getTrackTotalHits();
        query.setTrackTotalHits(Boolean.valueOf(true));
        SearchRequest searchRequest = this.requestFactory.searchRequest(query, this.routingResolver.getRouting(), clazz, index);
        query.setTrackTotalHits(trackTotalHits);
        searchRequest.source().size(0);
        return SearchHitsUtil.getTotalCount(this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT).getHits()));
    }

    public <T> SearchHits<T> search(Query query, Class<T> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.requestFactory.searchRequest(query, this.routingResolver.getRouting(), clazz, index);
        SearchResponse response = this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
        return (SearchHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback)));
    }

    protected <T> SearchHits<T> doSearch(MoreLikeThisQuery query, Class<T> clazz, IndexCoordinates index) {
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = this.requestFactory.moreLikeThisQueryBuilder(query, index);
        return this.search((Query)((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery((QueryBuilder)moreLikeThisQueryBuilder).withPageable(query.getPageable())).build(), clazz, index);
    }

    public <T> SearchScrollHits<T> searchScrollStart(long scrollTimeInMillis, Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query.getPageable(), (String)"pageable of query must not be null.");
        SearchRequest searchRequest = this.requestFactory.searchRequest(query, this.routingResolver.getRouting(), clazz, index);
        searchRequest.scroll(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        SearchResponse response = this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback)));
    }

    public <T> SearchScrollHits<T> searchScrollContinue(String scrollId, long scrollTimeInMillis, Class<T> clazz, IndexCoordinates index) {
        SearchScrollRequest request = new SearchScrollRequest(scrollId);
        request.scroll(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        SearchResponse response = this.execute(client -> client.scroll(request, RequestOptions.DEFAULT));
        AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback)));
    }

    public void searchScrollClear(List<String> scrollIds) {
        try {
            ClearScrollRequest request = new ClearScrollRequest();
            request.scrollIds(scrollIds);
            this.execute(client -> client.clearScroll(request, RequestOptions.DEFAULT));
        }
        catch (Exception e) {
            LOGGER.warn((Object)String.format("Could not clear scroll: %s", e.getMessage()));
        }
    }

    public String openPointInTime(IndexCoordinates index, Duration keepAlive, Boolean ignoreUnavailable) {
        CreatePitRequest createPitRequest = new CreatePitRequest(TimeValue.timeValueMillis((long)keepAlive.toMillis()), Boolean.valueOf(true), new String[]{index.getIndexName()});
        return this.execute(client -> client.createPit(createPitRequest, RequestOptions.DEFAULT)).getId();
    }

    public Boolean closePointInTime(String pit) {
        try {
            DeletePitRequest deletePitRequest = new DeletePitRequest(new String[]{pit});
            return ((DeletePitInfo)this.execute(client -> client.deletePit(deletePitRequest, RequestOptions.DEFAULT)).getDeletePitResults().get(0)).isSuccessful();
        }
        catch (Exception e) {
            LOGGER.warn((Object)String.format("Could not clear pit: %s", e.getMessage()));
            return false;
        }
    }

    @Override
    public List<OpenSearchOperations.PitInfo> listPointInTime() {
        return this.execute(client -> client.getAllPits(RequestOptions.DEFAULT)).getPitInfos().stream().map(pit -> new OpenSearchOperations.PitInfo(pit.getPitId(), pit.getCreationTime(), null)).toList();
    }

    public SearchResponse suggest(SuggestBuilder suggestion, IndexCoordinates index) {
        SearchRequest searchRequest = this.requestFactory.searchRequest(suggestion, index);
        return this.execute(client -> client.search(searchRequest, RequestOptions.DEFAULT));
    }

    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> queries, Class<T> clazz, IndexCoordinates index) {
        MultiSearchRequest request = new MultiSearchRequest();
        for (Query query : queries) {
            request.add(this.requestFactory.searchRequest(query, this.routingResolver.getRouting(), clazz, index));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        AbstractElasticsearchTemplate.ReadDocumentCallback readDocumentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, clazz, index);
        ArrayList<SearchHits<T>> res = new ArrayList<SearchHits<T>>(queries.size());
        for (int i = 0; i < queries.size(); ++i) {
            res.add((SearchHits)callback.doWith(SearchDocumentResponseBuilder.from(items[i].getResponse(), this.getEntityCreator(readDocumentCallback))));
        }
        return res;
    }

    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        for (Query query : queries) {
            Class<?> clazz = it.next();
            request.add(this.requestFactory.searchRequest(query, this.routingResolver.getRouting(), clazz, this.getIndexCoordinatesFor(clazz)));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList arrayList = new ArrayList(queries.size());
        Iterator<Class<?>> it1 = classes.iterator();
        for (int i = 0; i < queries.size(); ++i) {
            Class<?> entityClass = it1.next();
            IndexCoordinates index = this.getIndexCoordinatesFor(entityClass);
            AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, entityClass, index);
            AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, entityClass, index);
            SearchResponse response = items[i].getResponse();
            arrayList.add((SearchHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback))));
        }
        return arrayList;
    }

    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes, IndexCoordinates index) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"queries and classes must have the same size");
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        for (Query query : queries) {
            request.add(this.requestFactory.searchRequest(query, this.routingResolver.getRouting(), it.next(), index));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList arrayList = new ArrayList(queries.size());
        Iterator<Class<?>> it1 = classes.iterator();
        for (int i = 0; i < queries.size(); ++i) {
            Class<?> entityClass = it1.next();
            AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, entityClass, index);
            AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, entityClass, index);
            SearchResponse response = items[i].getResponse();
            arrayList.add((SearchHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback))));
        }
        return arrayList;
    }

    public List<SearchHits<?>> multiSearch(List<? extends Query> queries, List<Class<?>> classes, List<IndexCoordinates> indexes) {
        Assert.notNull(queries, (String)"queries must not be null");
        Assert.notNull(classes, (String)"classes must not be null");
        Assert.notNull(indexes, (String)"indexes must not be null");
        Assert.isTrue((queries.size() == classes.size() && queries.size() == indexes.size() ? 1 : 0) != 0, (String)"queries, classes and indexes must have the same size");
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        Iterator<IndexCoordinates> indexesIt = indexes.iterator();
        for (Query query : queries) {
            request.add(this.requestFactory.searchRequest(query, this.routingResolver.getRouting(), it.next(), indexesIt.next()));
        }
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList arrayList = new ArrayList(queries.size());
        Iterator<Class<?>> it1 = classes.iterator();
        Iterator<IndexCoordinates> indexesIt1 = indexes.iterator();
        for (int i = 0; i < queries.size(); ++i) {
            Class<?> entityClass = it1.next();
            IndexCoordinates index = indexesIt1.next();
            AbstractElasticsearchTemplate.ReadDocumentCallback documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback((AbstractElasticsearchTemplate)this, (EntityReader)this.elasticsearchConverter, entityClass, index);
            AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback((AbstractElasticsearchTemplate)this, entityClass, index);
            SearchResponse response = items[i].getResponse();
            arrayList.add((SearchHits)callback.doWith(SearchDocumentResponseBuilder.from(response, this.getEntityCreator(documentCallback))));
        }
        return arrayList;
    }

    protected MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest request) {
        MultiSearchResponse response = this.execute(client -> client.msearch(request, RequestOptions.DEFAULT));
        MultiSearchResponse.Item[] items = response.getResponses();
        Assert.isTrue((items.length == request.requests().size() ? 1 : 0) != 0, (String)"Response should has same length with queries");
        return items;
    }

    public SqlResponse search(SqlQuery query) {
        throw new UnsupportedOperationException("The operation search(SqlQuery query) is not supported");
    }

    public <T> T execute(ClientCallback<T> callback) {
        Assert.notNull(callback, (String)"callback must not be null");
        try {
            return callback.doWithClient(this.client);
        }
        catch (IOException | RuntimeException e) {
            throw this.translateException(e);
        }
    }

    private RuntimeException translateException(Exception exception) {
        RuntimeException runtimeException = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception.getMessage(), exception);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }

    public String getClusterVersion() {
        try {
            return this.execute(client -> client.info(RequestOptions.DEFAULT)).getVersion().getNumber();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Query matchAllQuery() {
        return new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
    }

    public Query idsQuery(List<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        return new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(ids.toArray(new String[0]))).build();
    }

    public String getVendor() {
        return "OpenSearch";
    }

    public String getRuntimeLibraryVersion() {
        return Version.CURRENT.toString();
    }

    @Deprecated
    public SearchResponse suggest(SuggestBuilder suggestion, Class<?> clazz) {
        return this.suggest(suggestion, this.getIndexCoordinatesFor(clazz));
    }

    public BaseQueryBuilder queryBuilderWithIds(List<String> ids) {
        return new NativeSearchQueryBuilder().withIds(ids);
    }

    private static /* synthetic */ MultiGetItem lambda$multiGet$3(AbstractElasticsearchTemplate.DocumentCallback callback, MultiGetItem multiGetItem) {
        return MultiGetItem.of(multiGetItem.isFailed() ? null : callback.doWith((Document)multiGetItem.getItem()), (MultiGetItem.Failure)multiGetItem.getFailure());
    }

    @FunctionalInterface
    public static interface ClientCallback<T> {
        public T doWithClient(RestHighLevelClient var1) throws IOException;
    }
}

