/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HybridQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, HybridQuery> {
    @Nullable
    private final Integer paginationDepth;
    @Nonnull
    private final List<Query> queries;
    public static final JsonpDeserializer<HybridQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HybridQuery::setupHybridQueryDeserializer);

    private HybridQuery(Builder builder) {
        super(builder);
        this.paginationDepth = builder.paginationDepth;
        this.queries = ApiTypeHelper.unmodifiable(builder.queries);
    }

    public static HybridQuery of(Function<Builder, ObjectBuilder<HybridQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Hybrid;
    }

    @Nullable
    public final Integer paginationDepth() {
        return this.paginationDepth;
    }

    @Nonnull
    public final List<Query> queries() {
        return this.queries;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.paginationDepth != null) {
            generator.writeKey("pagination_depth");
            generator.write(this.paginationDepth.intValue());
        }
        if (ApiTypeHelper.isDefined(this.queries)) {
            generator.writeKey("queries");
            generator.writeStartArray();
            for (Query item0 : this.queries) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHybridQueryDeserializer(ObjectDeserializer<Builder> op) {
        HybridQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::paginationDepth, JsonpDeserializer.integerDeserializer(), "pagination_depth");
        op.add(Builder::queries, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "queries");
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.paginationDepth);
        result = 31 * result + Objects.hashCode(this.queries);
        return result;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HybridQuery other = (HybridQuery)o;
        return Objects.equals(this.paginationDepth, other.paginationDepth) && Objects.equals(this.queries, other.queries);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, HybridQuery> {
        @Nullable
        private Integer paginationDepth;
        @Nullable
        private List<Query> queries;

        public Builder() {
        }

        private Builder(HybridQuery o) {
            super(o);
            this.paginationDepth = o.paginationDepth;
            this.queries = Builder._listCopy(o.queries);
        }

        private Builder(Builder o) {
            super(o);
            this.paginationDepth = o.paginationDepth;
            this.queries = Builder._listCopy(o.queries);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder paginationDepth(@Nullable Integer value) {
            this.paginationDepth = value;
            return this;
        }

        @Nonnull
        public final Builder queries(List<Query> list) {
            this.queries = Builder._listAddAll(this.queries, list);
            return this;
        }

        @Nonnull
        public final Builder queries(Query value, Query ... values) {
            this.queries = Builder._listAdd(this.queries, value, values);
            return this;
        }

        @Nonnull
        public final Builder queries(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.queries(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Override
        @Nonnull
        public HybridQuery build() {
            this._checkSingleUse();
            return new HybridQuery(this);
        }
    }
}

