/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.simulate;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingest.simulate.DocumentSimulation;
import org.opensearch.client.util.ActionStatusOptions;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class PipelineSimulation
implements PlainJsonSerializable {
    @Nullable
    private final DocumentSimulation doc;
    private final List<PipelineSimulation> processorResults;
    @Nullable
    private final String tag;
    @Nullable
    private final String processorType;
    @Nullable
    private final ActionStatusOptions status;
    public static final JsonpDeserializer<PipelineSimulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineSimulation::setupPipelineSimulationDeserializer);

    private PipelineSimulation(Builder builder) {
        this.doc = builder.doc;
        this.processorResults = ApiTypeHelper.unmodifiable(builder.processorResults);
        this.tag = builder.tag;
        this.processorType = builder.processorType;
        this.status = builder.status;
    }

    public static PipelineSimulation of(Function<Builder, ObjectBuilder<PipelineSimulation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DocumentSimulation doc() {
        return this.doc;
    }

    public final List<PipelineSimulation> processorResults() {
        return this.processorResults;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Nullable
    public final String processorType() {
        return this.processorType;
    }

    @Nullable
    public final ActionStatusOptions status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.processorResults)) {
            generator.writeKey("processor_results");
            generator.writeStartArray();
            for (PipelineSimulation item0 : this.processorResults) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
        if (this.processorType != null) {
            generator.writeKey("processor_type");
            generator.write(this.processorType);
        }
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
    }

    protected static void setupPipelineSimulationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::doc, DocumentSimulation._DESERIALIZER, "doc");
        op.add(Builder::processorResults, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "processor_results");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
        op.add(Builder::processorType, JsonpDeserializer.stringDeserializer(), "processor_type");
        op.add(Builder::status, ActionStatusOptions._DESERIALIZER, "status");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PipelineSimulation> {
        @Nullable
        private DocumentSimulation doc;
        @Nullable
        private List<PipelineSimulation> processorResults;
        @Nullable
        private String tag;
        @Nullable
        private String processorType;
        @Nullable
        private ActionStatusOptions status;

        public final Builder doc(@Nullable DocumentSimulation value) {
            this.doc = value;
            return this;
        }

        public final Builder doc(Function<DocumentSimulation.Builder, ObjectBuilder<DocumentSimulation>> fn) {
            return this.doc(fn.apply(new DocumentSimulation.Builder()).build());
        }

        public final Builder processorResults(List<PipelineSimulation> list) {
            this.processorResults = Builder._listAddAll(this.processorResults, list);
            return this;
        }

        public final Builder processorResults(PipelineSimulation value, PipelineSimulation ... values) {
            this.processorResults = Builder._listAdd(this.processorResults, value, values);
            return this;
        }

        public final Builder processorResults(Function<Builder, ObjectBuilder<PipelineSimulation>> fn) {
            return this.processorResults(fn.apply(new Builder()).build(), new PipelineSimulation[0]);
        }

        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        public final Builder processorType(@Nullable String value) {
            this.processorType = value;
            return this;
        }

        public final Builder status(@Nullable ActionStatusOptions value) {
            this.status = value;
            return this;
        }

        @Override
        public PipelineSimulation build() {
            this._checkSingleUse();
            return new PipelineSimulation(this);
        }
    }
}

