/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElement;

public class Atom
extends AtomType
implements IAtom,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3137373012494608794L;
    protected Point2d point2d = (Point2d)CDKConstants.UNSET;
    protected Point3d point3d = (Point3d)CDKConstants.UNSET;
    protected Point3d fractionalPoint3d = (Point3d)CDKConstants.UNSET;
    protected Integer hydrogenCount = (Integer)CDKConstants.UNSET;
    protected Integer stereoParity = (Integer)CDKConstants.UNSET;
    protected Double charge = (Double)CDKConstants.UNSET;

    public Atom() {
        super((String)null);
    }

    public Atom(int elem) {
        this(elem, 0, 0);
    }

    public Atom(int elem, int hcnt) {
        this(elem, hcnt, 0);
    }

    public Atom(int elem, int hcnt, int fchg) {
        super((String)null);
        this.setAtomicNumber(elem);
        this.setSymbol(Elements.ofNumber((int)elem).symbol());
        this.setImplicitHydrogenCount(hcnt);
        this.setFormalCharge(fchg);
    }

    public Atom(String symbol) {
        super((String)null);
        if (!Atom.parseAtomSymbol(this, symbol)) {
            throw new IllegalArgumentException("Cannot pass atom symbol: " + symbol);
        }
    }

    public Atom(String elementSymbol, Point3d point3d) {
        this(elementSymbol);
        this.point3d = point3d;
    }

    public Atom(String elementSymbol, Point2d point2d) {
        this(elementSymbol);
        this.point2d = point2d;
    }

    public Atom(IElement element) {
        super(element);
        if (element instanceof IAtom) {
            this.point2d = ((IAtom)element).getPoint2d() != null ? new Point2d(((IAtom)element).getPoint2d()) : null;
            this.point3d = ((IAtom)element).getPoint3d() != null ? new Point3d(((IAtom)element).getPoint3d()) : null;
            this.fractionalPoint3d = ((IAtom)element).getFractionalPoint3d() != null ? new Point3d(((IAtom)element).getFractionalPoint3d()) : null;
            this.hydrogenCount = ((IAtom)element).getImplicitHydrogenCount();
            this.charge = ((IAtom)element).getCharge();
            this.stereoParity = ((IAtom)element).getStereoParity();
        }
    }

    public IAtomContainer getContainer() {
        return null;
    }

    public int getIndex() {
        return -1;
    }

    public Iterable<IBond> bonds() {
        throw new UnsupportedOperationException();
    }

    public int getBondCount() {
        throw new UnsupportedOperationException();
    }

    public void setCharge(Double charge) {
        this.charge = charge;
        this.notifyChanged();
    }

    public Double getCharge() {
        return this.charge;
    }

    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.hydrogenCount = hydrogenCount;
        this.notifyChanged();
    }

    public Integer getImplicitHydrogenCount() {
        return this.hydrogenCount;
    }

    public void setPoint2d(Point2d point2d) {
        this.point2d = point2d;
        this.notifyChanged();
    }

    public void setPoint3d(Point3d point3d) {
        this.point3d = point3d;
        this.notifyChanged();
    }

    public void setFractionalPoint3d(Point3d point3d) {
        this.fractionalPoint3d = point3d;
        this.notifyChanged();
    }

    public void setStereoParity(Integer stereoParity) {
        this.stereoParity = stereoParity;
        this.notifyChanged();
    }

    public Point2d getPoint2d() {
        return this.point2d;
    }

    public Point3d getPoint3d() {
        return this.point3d;
    }

    public Point3d getFractionalPoint3d() {
        return this.fractionalPoint3d;
    }

    public Integer getStereoParity() {
        return this.stereoParity;
    }

    @Override
    public boolean compare(Object object) {
        if (!(object instanceof IAtom)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Atom atom = (Atom)object;
        return (this.point2d == atom.point2d || this.point2d != null && this.point2d.equals((Tuple2d)atom.point2d)) && (this.point3d == atom.point3d || this.point3d != null && this.point3d.equals((Tuple3d)atom.point3d)) && Objects.equals(this.hydrogenCount, atom.hydrogenCount) && Objects.equals(this.stereoParity, atom.stereoParity) && Objects.equals(this.charge, atom.charge);
    }

    public boolean isAromatic() {
        return this.getFlag(32);
    }

    public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    public boolean isInRing() {
        return this.getFlag(2);
    }

    public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer(64);
        stringContent.append("Atom(").append(this.hashCode());
        if (this.getSymbol() != null) {
            stringContent.append(", S:").append(this.getSymbol());
        }
        if (this.getImplicitHydrogenCount() != null) {
            stringContent.append(", H:").append(this.getImplicitHydrogenCount());
        }
        if (this.getStereoParity() != null) {
            stringContent.append(", SP:").append(this.getStereoParity());
        }
        if (this.getPoint2d() != null) {
            stringContent.append(", 2D:[").append(this.getPoint2d()).append(']');
        }
        if (this.getPoint3d() != null) {
            stringContent.append(", 3D:[").append(this.getPoint3d()).append(']');
        }
        if (this.getFractionalPoint3d() != null) {
            stringContent.append(", F3D:[").append(this.getFractionalPoint3d());
        }
        if (this.getCharge() != null) {
            stringContent.append(", C:").append(this.getCharge());
        }
        stringContent.append(", ").append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    public IAtom clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        if (this.point2d != null) {
            ((Atom)clone).setPoint2d(new Point2d(this.point2d.x, this.point2d.y));
        }
        if (this.point3d != null) {
            ((Atom)clone).setPoint3d(new Point3d(this.point3d.x, this.point3d.y, this.point3d.z));
        }
        if (this.fractionalPoint3d != null) {
            ((Atom)clone).setFractionalPoint3d(new Point3d(this.fractionalPoint3d.x, this.fractionalPoint3d.y, this.fractionalPoint3d.z));
        }
        return (IAtom)clone;
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean parseAtomSymbol(IAtom atom, String str) {
        int len = str.length();
        int pos = 0;
        int mass = -1;
        int anum = 0;
        int hcnt = 0;
        int chg = 0;
        if (pos < len && Atom.isDigit(str.charAt(pos))) {
            mass = str.charAt(pos++) - 48;
            while (pos < len && Atom.isDigit(str.charAt(pos))) {
                mass = 10 * mass + (str.charAt(pos++) - 48);
            }
        } else {
            if ("R".equals(str)) {
                atom.setAtomicNumber(Integer.valueOf(0));
                atom.setSymbol("R");
                return true;
            }
            if ("*".equals(str)) {
                atom.setAtomicNumber(Integer.valueOf(0));
                atom.setSymbol("*");
                return true;
            }
            if ("D".equals(str)) {
                atom.setAtomicNumber(Integer.valueOf(1));
                atom.setMassNumber(Integer.valueOf(2));
                atom.setSymbol("H");
                return true;
            }
            if ("T".equals(str)) {
                atom.setAtomicNumber(Integer.valueOf(1));
                atom.setMassNumber(Integer.valueOf(3));
                atom.setSymbol("H");
                return true;
            }
        }
        if (pos < len && Atom.isUpper(str.charAt(pos))) {
            int beg = pos++;
            while (pos < len && Atom.isLower(str.charAt(pos))) {
                ++pos;
            }
            Elements elem = Elements.ofString((String)str.substring(beg, pos));
            if (elem == Elements.Unknown) {
                return false;
            }
            anum = elem.number();
            block7: while (pos < len) {
                switch (str.charAt(pos)) {
                    case 'H': {
                        if (++pos < len && Atom.isDigit(str.charAt(pos))) {
                            while (pos < len && Atom.isDigit(str.charAt(pos))) {
                                hcnt = 10 * hcnt + (str.charAt(pos++) - 48);
                            }
                            continue block7;
                        }
                        hcnt = 1;
                        continue block7;
                    }
                    case '+': {
                        if (++pos < len && Atom.isDigit(str.charAt(pos))) {
                            chg = str.charAt(pos++) - 48;
                            while (pos < len && Atom.isDigit(str.charAt(pos))) {
                                chg = 10 * chg + (str.charAt(pos++) - 48);
                            }
                            continue block7;
                        }
                        chg = 1;
                        continue block7;
                    }
                    case '-': {
                        if (++pos < len && Atom.isDigit(str.charAt(pos))) {
                            chg = str.charAt(pos++) - 48;
                            while (pos < len && Atom.isDigit(str.charAt(pos))) {
                                chg = 10 * chg + (str.charAt(pos++) - 48);
                            }
                            chg *= -1;
                            continue block7;
                        }
                        chg = -1;
                        continue block7;
                    }
                }
                return false;
            }
        } else {
            return false;
        }
        if (mass < 0) {
            atom.setMassNumber(null);
        } else {
            atom.setMassNumber(Integer.valueOf(mass));
        }
        atom.setAtomicNumber(Integer.valueOf(anum));
        atom.setSymbol(Elements.ofNumber((int)anum).symbol());
        atom.setImplicitHydrogenCount(Integer.valueOf(hcnt));
        atom.setFormalCharge(Integer.valueOf(chg));
        return pos == len && len > 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AtomRef) {
            return super.equals(((AtomRef)obj).deref());
        }
        return super.equals(obj);
    }
}

