/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class MDLV3000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV3000Reader.class);
    private Pattern keyValueTuple;
    private Pattern keyValueTuple2;
    private int lineNumber;

    public MDLV3000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
        this.keyValueTuple = Pattern.compile("\\s*(\\w+)=([^\\s]*)(.*)");
        this.keyValueTuple2 = Pattern.compile("\\s*(\\w+)=\\(([^\\)]*)\\)(.*)");
        this.lineNumber = 0;
    }

    public MDLV3000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLV3000Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return MDLV3000Format.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.lineNumber = 0;
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule(object.getBuilder());
        }
        throw new CDKException("Only supports AtomContainer objects.");
    }

    public IAtomContainer readMolecule(IChemObjectBuilder builder) throws CDKException {
        return this.readConnectionTable(builder);
    }

    public IAtomContainer readConnectionTable(IChemObjectBuilder builder) throws CDKException {
        logger.info((Object)"Reading CTAB block");
        IAtomContainer readData = builder.newAtomContainer();
        boolean foundEND = false;
        String lastLine = this.readHeader(readData);
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(lastLine);
            logger.debug((Object)("command found: " + command));
            if ("END CTAB".equals(command)) {
                foundEND = true;
            } else if (!"BEGIN CTAB".equals(command) && !"COUNTS".equals(command)) {
                if ("BEGIN ATOM".equals(command)) {
                    this.readAtomBlock(readData);
                } else if ("BEGIN BOND".equals(command)) {
                    this.readBondBlock(readData);
                } else if ("BEGIN SGROUP".equals(command)) {
                    this.readSGroup(readData);
                } else {
                    logger.warn((Object)("Unrecognized command: " + command));
                }
            }
            lastLine = this.readLine();
        }
        for (IAtom atom : readData.atoms()) {
            int valence = 0;
            for (IBond bond : readData.getConnectedBondsList(atom)) {
                if (bond instanceof IQueryBond || bond.getOrder() == IBond.Order.UNSET) {
                    valence = -1;
                    break;
                }
                valence += bond.getOrder().numeric().intValue();
            }
            if (valence < 0) {
                logger.warn((Object)"Cannot set valence for atom with query bonds");
                continue;
            }
            int unpaired = readData.getConnectedSingleElectronsCount(atom);
            this.applyMDLValenceModel(atom, valence + unpaired, unpaired);
        }
        return readData;
    }

    public String readHeader(IAtomContainer readData) throws CDKException {
        String line4;
        String line1 = this.readLine();
        if (line1 == null) {
            throw new CDKException("Expected a header line, but found nothing.");
        }
        if (line1.length() > 0) {
            if (line1.startsWith("M  V30")) {
                return line1;
            }
            readData.setTitle(line1);
        }
        this.readLine();
        String line3 = this.readLine();
        if (line3.length() > 0) {
            readData.setProperty((Object)"cdk:Comment", (Object)line3);
        }
        if (!(line4 = this.readLine()).contains("3000")) {
            throw new CDKException("This file is not a MDL V3000 molfile.");
        }
        return this.readLine();
    }

    public void readAtomBlock(IAtomContainer readData) throws CDKException {
        Isotopes isotopeFactory;
        logger.info((Object)"Reading ATOM block");
        try {
            isotopeFactory = Isotopes.getInstance();
        }
        catch (IOException exception) {
            throw new CDKException("Could not initiate the IsotopeFactory.", (Throwable)exception);
        }
        int RGroupCounter = 1;
        int Rnumber = 0;
        String[] rGroup = null;
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END ATOM".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing atom from: " + command));
            IAtom atom = readData.getBuilder().newAtom();
            StringTokenizer tokenizer = new StringTokenizer(command);
            try {
                atom.setID(tokenizer.nextToken());
            }
            catch (Exception exception) {
                String error = "Error while parsing atom index";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            String element = tokenizer.nextToken();
            if (isotopeFactory.isElement(element)) {
                atom.setSymbol(element);
                isotopeFactory.configure(atom);
            } else if ("A".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("Q".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("*".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("LP".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if ("L".equals(element)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else if (element.length() > 0 && element.charAt(0) == 'R') {
                logger.debug((Object)"Atom ", new Object[]{element, " is not an regular element. Creating a PseudoAtom."});
                rGroup = element.split("^R");
                if (rGroup.length > 1) {
                    try {
                        RGroupCounter = Rnumber = Integer.valueOf(rGroup[rGroup.length - 1]).intValue();
                    }
                    catch (Exception ex) {
                        Rnumber = RGroupCounter++;
                    }
                    element = "R" + Rnumber;
                }
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
            } else {
                if (this.mode == IChemObjectReader.Mode.STRICT) {
                    throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                }
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{element});
                atom.setSymbol(element);
            }
            try {
                String xString = tokenizer.nextToken();
                String yString = tokenizer.nextToken();
                String zString = tokenizer.nextToken();
                double x = Double.parseDouble(xString);
                double y = Double.parseDouble(yString);
                double z = Double.parseDouble(zString);
                atom.setPoint3d(new Point3d(x, y, z));
                atom.setPoint2d(new Point2d(x, y));
            }
            catch (Exception exception) {
                String error = "Error while parsing atom coordinates";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            String mapping = tokenizer.nextToken();
            if (!mapping.equals("0")) {
                logger.warn((Object)("Skipping atom-atom mapping: " + mapping));
            }
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block23: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        switch (key) {
                            case "CHG": {
                                int charge = Integer.parseInt(value);
                                if (charge == 0) continue block23;
                                atom.setFormalCharge(Integer.valueOf(charge));
                                break;
                            }
                            case "RAD": {
                                int numElectons = MDLV2000Writer.SPIN_MULTIPLICITY.ofValue(Integer.parseInt(value)).getSingleElectrons();
                                while (numElectons-- > 0) {
                                    readData.addSingleElectron((ISingleElectron)readData.getBuilder().newInstance(ISingleElectron.class, new Object[]{atom}));
                                }
                                continue block23;
                            }
                            case "VAL": {
                                if (!(atom instanceof IPseudoAtom)) {
                                    try {
                                        int valence = Integer.parseInt(value);
                                        if (valence == 0) continue block23;
                                        if (valence == 15) {
                                            atom.setValency(Integer.valueOf(0));
                                            break;
                                        }
                                        atom.setValency(Integer.valueOf(valence));
                                    }
                                    catch (Exception exception) {
                                        this.handleError("Could not parse valence information field", this.lineNumber, 0, 0, exception);
                                    }
                                    break;
                                }
                                logger.error((Object)"Cannot set valence information for a non-element!");
                                break;
                            }
                            default: {
                                logger.warn((Object)("Not parsing key: " + key));
                            }
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)error);
                        logger.debug((Object)exception);
                        throw new CDKException(error, (Throwable)exception);
                    }
                }
            }
            readData.addAtom(atom);
            logger.debug((Object)("Added atom: " + atom));
        }
    }

    public void readBondBlock(IAtomContainer readData) throws CDKException {
        logger.info((Object)"Reading BOND block");
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String error;
            String command = this.readCommand(this.readLine());
            if ("END BOND".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing bond from: " + command));
            StringTokenizer tokenizer = new StringTokenizer(command);
            IBond bond = readData.getBuilder().newBond();
            try {
                String indexString = tokenizer.nextToken();
                bond.setID(indexString);
            }
            catch (Exception exception) {
                error = "Error while parsing bond index";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            try {
                String orderString = tokenizer.nextToken();
                int order = Integer.parseInt(orderString);
                if (order >= 4) {
                    logger.warn((Object)"Query order types are not supported (yet). File a bug if you need it");
                } else {
                    bond.setOrder(BondManipulator.createBondOrder((double)order));
                }
            }
            catch (Exception exception) {
                error = "Error while parsing bond index";
                logger.error((Object)error);
                logger.debug((Object)exception);
                throw new CDKException(error, (Throwable)exception);
            }
            try {
                String indexAtom1String = tokenizer.nextToken();
                int indexAtom1 = Integer.parseInt(indexAtom1String);
                IAtom atom1 = readData.getAtom(indexAtom1 - 1);
                bond.setAtom(atom1, 0);
            }
            catch (Exception exception) {
                String error2 = "Error while parsing index atom 1 in bond";
                logger.error((Object)error2);
                logger.debug((Object)exception);
                throw new CDKException(error2, (Throwable)exception);
            }
            try {
                String indexAtom2String = tokenizer.nextToken();
                int indexAtom2 = Integer.parseInt(indexAtom2String);
                IAtom atom2 = readData.getAtom(indexAtom2 - 1);
                bond.setAtom(atom2, 1);
            }
            catch (Exception exception) {
                String error3 = "Error while parsing index atom 2 in bond";
                logger.error((Object)error3);
                logger.debug((Object)exception);
                throw new CDKException(error3, (Throwable)exception);
            }
            ArrayList<IAtom> endpts = new ArrayList<IAtom>();
            String attach = null;
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block21: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        switch (key) {
                            case "CFG": {
                                int configuration = Integer.parseInt(value);
                                if (configuration == 0) {
                                    bond.setStereo(IBond.Stereo.NONE);
                                    break;
                                }
                                if (configuration == 1) {
                                    bond.setStereo(IBond.Stereo.UP);
                                    break;
                                }
                                if (configuration == 2) {
                                    bond.setStereo((IBond.Stereo)CDKConstants.UNSET);
                                    break;
                                }
                                if (configuration != 3) continue block21;
                                bond.setStereo(IBond.Stereo.DOWN);
                                break;
                            }
                            case "ENDPTS": {
                                String[] endptStr = value.split(" ");
                                for (int i = 1; i < endptStr.length; ++i) {
                                    endpts.add(readData.getAtom(Integer.parseInt(endptStr[i]) - 1));
                                }
                                continue block21;
                            }
                            case "ATTACH": {
                                attach = value;
                                break;
                            }
                            default: {
                                logger.warn((Object)("Not parsing key: " + key));
                            }
                        }
                    }
                    catch (Exception exception) {
                        String error4 = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)error4);
                        logger.debug((Object)exception);
                        throw new CDKException(error4, (Throwable)exception);
                    }
                }
            }
            readData.addBond(bond);
            if ("ANY".equals(attach)) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtMulticenter);
                sgroup.addAtom(bond.getBegin());
                sgroup.addBond(bond);
                for (IAtom endpt : endpts) {
                    sgroup.addAtom(endpt);
                }
                ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)readData.getProperty((Object)"cdk:CtabSgroups");
                if (sgroups == null) {
                    sgroups = new ArrayList<Sgroup>(4);
                    readData.setProperty((Object)"cdk:CtabSgroups", sgroups);
                }
                sgroups.add(sgroup);
            }
            logger.debug((Object)("Added bond: " + bond));
        }
    }

    public void readSGroup(IAtomContainer readData) throws CDKException {
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END SGROUP".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing Sgroup line: " + command));
            StringTokenizer tokenizer = new StringTokenizer(command);
            String indexString = tokenizer.nextToken();
            logger.warn((Object)("Skipping external index: " + indexString));
            String type = tokenizer.nextToken();
            String externalIndexString = tokenizer.nextToken();
            logger.warn((Object)("Skipping external index: " + externalIndexString));
            Map<Object, Object> options = new Hashtable();
            if (command.indexOf(61) != -1) {
                options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
            }
            if (type.startsWith("SUP")) {
                Iterator keys = options.keySet().iterator();
                int atomID = -1;
                String label = "";
                while (keys.hasNext()) {
                    IAtom original;
                    String key = (String)keys.next();
                    String value = (String)options.get(key);
                    try {
                        if (key.equals("ATOMS")) {
                            StringTokenizer atomsTokenizer = new StringTokenizer(value);
                            Integer.parseInt(atomsTokenizer.nextToken());
                            atomID = Integer.parseInt(atomsTokenizer.nextToken());
                        } else if (key.equals("LABEL")) {
                            label = value;
                        } else {
                            logger.warn((Object)("Not parsing key: " + key));
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)error);
                        logger.debug((Object)exception);
                        throw new CDKException(error, (Throwable)exception);
                    }
                    if (atomID == -1 || label.length() <= 0) continue;
                    IAtom replacement = original = readData.getAtom(atomID - 1);
                    if (!(original instanceof IPseudoAtom)) {
                        replacement = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{original});
                    }
                    ((IPseudoAtom)replacement).setLabel(label);
                    if (replacement.equals(original)) continue;
                    AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)readData, (IAtom)original, (IAtom)replacement);
                }
                continue;
            }
            logger.warn((Object)("Skipping unrecognized SGROUP type: " + type));
        }
    }

    private String readCommand(String line) throws CDKException {
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand(this.readLine());
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    private Map<String, String> parseOptions(String string) throws CDKException {
        Hashtable<String, String> keyValueTuples = new Hashtable<String, String>();
        while (string.length() >= 3) {
            logger.debug((Object)("Matching remaining option string: " + string));
            Matcher tuple1Matcher = this.keyValueTuple2.matcher(string);
            if (tuple1Matcher.matches()) {
                String key = tuple1Matcher.group(1);
                String value = tuple1Matcher.group(2);
                string = tuple1Matcher.group(3);
                logger.debug((Object)("Found key: " + key));
                logger.debug((Object)("Found value: " + value));
                keyValueTuples.put(key, value);
                continue;
            }
            Matcher tuple2Matcher = this.keyValueTuple.matcher(string);
            if (tuple2Matcher.matches()) {
                String key = tuple2Matcher.group(1);
                String value = tuple2Matcher.group(2);
                string = tuple2Matcher.group(3);
                logger.debug((Object)("Found key: " + key));
                logger.debug((Object)("Found value: " + value));
                keyValueTuples.put(key, value);
                continue;
            }
            logger.warn((Object)("Quiting; could not parse: " + string + "."));
            string = "";
        }
        return keyValueTuples;
    }

    public String exhaustStringTokenizer(StringTokenizer tokenizer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(' ');
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public String readLine() throws CDKException {
        String line = null;
        try {
            line = this.input.readLine();
            ++this.lineNumber;
            logger.debug((Object)("read line " + this.lineNumber + ":"), new Object[]{line});
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
        return line;
    }

    public boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
    }

    private void applyMDLValenceModel(IAtom atom, int explicitValence, int unpaired) {
        if (atom.getValency() != null) {
            if (atom.getValency() >= explicitValence) {
                atom.setImplicitHydrogenCount(Integer.valueOf(atom.getValency() - (explicitValence - unpaired)));
            } else {
                atom.setImplicitHydrogenCount(Integer.valueOf(0));
            }
        } else {
            int implicitValence;
            Integer charge;
            Integer element = atom.getAtomicNumber();
            if (element == null) {
                element = 0;
            }
            if ((charge = atom.getFormalCharge()) == null) {
                charge = 0;
            }
            if ((implicitValence = MDLValence.implicitValence(element, charge, explicitValence)) < explicitValence) {
                atom.setValency(Integer.valueOf(explicitValence));
                atom.setImplicitHydrogenCount(Integer.valueOf(0));
            } else {
                atom.setValency(Integer.valueOf(implicitValence));
                atom.setImplicitHydrogenCount(Integer.valueOf(implicitValence - explicitValence));
            }
        }
    }
}

